/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer.document;

import com.eucalyptus.reporting.art.renderer.document.Document;
import java.io.IOException;
import java.io.Writer;

public class HtmlDocument
implements Document {
    private static final int LABEL_WIDTH = 50;
    private static final int VALUE_WIDTH = 80;
    private StringBuilder rowSb;
    private Writer writer;
    private boolean rowHasLabel = false;
    private int rowIndent = 3;

    @Override
    public void setUnlabeledRowIndent(int num) {
        this.rowIndent = num;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Document open() throws IOException {
        this.writer.write("<html><body>\n");
        return this;
    }

    @Override
    public Document close() throws IOException {
        this.writer.write("</body></html>\n");
        this.writer.flush();
        return this;
    }

    @Override
    public Document tableOpen() throws IOException {
        this.writer.write("<table style=\"white-space: nowrap\">\n");
        return this;
    }

    @Override
    public Document tableClose() throws IOException {
        if (this.rowSb != null && this.rowSb.length() != 0) {
            this.writer.write("<tr>" + this.rowSb.toString() + "</tr>\n");
        }
        this.writer.write("</table>\n");
        this.rowSb = new StringBuilder();
        return this;
    }

    @Override
    public Document textLine(String text, int emphasis) throws IOException {
        this.writer.write(String.format("<h%d>%s</h%d>\n", emphasis, text, emphasis));
        return this;
    }

    @Override
    public Document newRow() throws IOException {
        this.rowHasLabel = false;
        if (this.rowSb != null && this.rowSb.length() != 0) {
            this.writer.write("<tr>" + this.rowSb.toString() + "</tr>\n");
        }
        this.rowSb = new StringBuilder();
        return this;
    }

    @Override
    public Document addLabelCol(int indent, String val) throws IOException {
        this.addEmptyLabelCols(indent);
        this.rowSb.append(String.format("<td width=\"%d\" colspan=\"%d\" align=\"left\">%s</td>", 50, this.rowIndent - indent, val));
        this.rowHasLabel = true;
        return this;
    }

    @Override
    public Document addValCol(String val) throws IOException {
        return this.addCol(val, 80, 1, "center");
    }

    @Override
    public Document addValCol(Integer val) throws IOException {
        return this.addCol(val == null ? "-" : val.toString(), 80, 1, "center");
    }

    @Override
    public Document addValCol(Long val) throws IOException {
        return this.addCol(val == null ? "-" : val.toString(), 80, 1, "center");
    }

    @Override
    public Document addValCol(Double val) throws IOException {
        return this.addCol(val == null ? "-" : String.format("%3.1f", val), 80, 1, "center");
    }

    @Override
    public HtmlDocument addValCol(String val, int colspan, String align) throws IOException {
        return this.addCol(val, 80, colspan, align);
    }

    private HtmlDocument addCol(String val, int width, int colspan, String align) throws IOException {
        if (!this.rowHasLabel) {
            this.addEmptyLabelCols(this.rowIndent);
            this.rowHasLabel = true;
        }
        this.rowSb.append(String.format("<td width=\"%d\" colspan=\"%d\" align=\"%s\">%s</td>", width, colspan, align, val));
        return this;
    }

    @Override
    public HtmlDocument addEmptyValCols(int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.rowSb.append("<td width=\"80\">&nbsp;</td>");
        }
        return this;
    }

    @Override
    public Document addEmptyLabelCols(int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.rowSb.append("<td width=\"50\">&nbsp;</td>");
        }
        return this;
    }
}

