/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer.document;

import com.eucalyptus.reporting.art.renderer.document.Document;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CsvDocument
implements Document {
    private List<String> colVals = null;
    private Writer writer;
    private boolean rowHasLabel = false;
    private int rowIndent = 3;

    @Override
    public void setUnlabeledRowIndent(int num) {
        this.rowIndent = num;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Document open() throws IOException {
        return this;
    }

    @Override
    public Document close() throws IOException {
        this.writer.flush();
        return this;
    }

    @Override
    public Document tableOpen() throws IOException {
        return this;
    }

    private void writeRow() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.colVals.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.colVals.get(i));
        }
        sb.append("\n");
        this.writer.write(sb.toString());
    }

    @Override
    public Document tableClose() throws IOException {
        if (this.colVals != null) {
            this.writeRow();
        }
        this.colVals = new ArrayList<String>();
        return this;
    }

    @Override
    public Document textLine(String text, int emphasis) throws IOException {
        this.writer.write(text + "\n");
        return this;
    }

    @Override
    public Document newRow() throws IOException {
        if (this.colVals != null && !this.colVals.isEmpty()) {
            this.writeRow();
        }
        this.colVals = new ArrayList<String>();
        this.rowHasLabel = false;
        return this;
    }

    @Override
    public Document addLabelCol(int indent, String val) throws IOException {
        this.rowHasLabel = true;
        this.addEmptyLabelCols(indent);
        this.addCol(val, 1);
        this.addEmptyLabelCols(this.rowIndent - (indent + 1));
        return this;
    }

    @Override
    public Document addValCol(String val) throws IOException {
        return this.addCol(val, 1);
    }

    @Override
    public Document addValCol(Integer val) throws IOException {
        return this.addCol(val == null ? null : val.toString(), 1);
    }

    @Override
    public Document addValCol(Long val) throws IOException {
        return this.addCol(val == null ? null : val.toString(), 1);
    }

    @Override
    public Document addValCol(Double val) throws IOException {
        return this.addCol(val == null ? null : String.format("%3.1f", val), 1);
    }

    @Override
    public CsvDocument addValCol(String val, int colspan, String align) throws IOException {
        return this.addCol(val, colspan);
    }

    private CsvDocument addCol(String val, int colspan) throws IOException {
        if (!this.rowHasLabel) {
            this.addEmptyLabelCols(this.rowIndent);
            this.rowHasLabel = true;
        }
        this.colVals.add(val);
        for (int i = 1; i < colspan; ++i) {
            this.colVals.add("");
        }
        return this;
    }

    @Override
    public CsvDocument addEmptyValCols(int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.colVals.add("");
        }
        return this;
    }

    @Override
    public Document addEmptyLabelCols(int num) throws IOException {
        for (int i = 0; i < num; ++i) {
            this.colVals.add("");
        }
        return this;
    }
}

