/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeSnapshotUsageArtEntity;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.UnitUtil;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

class VolumeSnapshotRenderer
implements Renderer {
    private Document doc;

    public VolumeSnapshotRenderer(Document doc) {
        this.doc = doc;
    }

    @Override
    public void render(ReportArtEntity report, OutputStream os, Units units) throws IOException {
        this.doc.setWriter(new OutputStreamWriter(os));
        this.doc.open();
        this.doc.textLine("Volume Snapshot Report", 1);
        this.doc.textLine("Begin:" + new Date(report.getBeginMs()).toString(), 4);
        this.doc.textLine("End:" + new Date(report.getEndMs()).toString(), 4);
        this.doc.textLine("Resource Usage Section", 3);
        this.doc.tableOpen();
        this.doc.newRow().addValCol("Volume Id").addValCol("Snapshot Id").addValCol("# Snap").addValCol("Size (" + units.labelForSize() + ")").addValCol(units.labelForSizeTime());
        for (String zoneName : report.getZones().keySet()) {
            AvailabilityZoneArtEntity zone = report.getZones().get(zoneName);
            this.doc.newRow().addLabelCol(0, "Zone: " + zoneName).addValCol("cumul.").addValCol("cumul.");
            VolumeSnapshotRenderer.addUsageCols(this.doc, zone.getUsageTotals().getSnapshotTotals(), units);
            for (String accountName : zone.getAccounts().keySet()) {
                AccountArtEntity account = zone.getAccounts().get(accountName);
                this.doc.newRow().addLabelCol(1, "Account: " + accountName).addValCol("cumul.").addValCol("cumul.");
                VolumeSnapshotRenderer.addUsageCols(this.doc, account.getUsageTotals().getSnapshotTotals(), units);
                for (String userName : account.getUsers().keySet()) {
                    UserArtEntity user = account.getUsers().get(userName);
                    this.doc.newRow().addLabelCol(2, "User: " + userName).addValCol("cumul.").addValCol("cumul.");
                    VolumeSnapshotRenderer.addUsageCols(this.doc, user.getUsageTotals().getSnapshotTotals(), units);
                    for (String volumeUuid : user.getVolumes().keySet()) {
                        VolumeArtEntity volume = user.getVolumes().get(volumeUuid);
                        this.doc.newRow().addValCol(volume.getVolumeId()).addValCol("cumul.");
                        VolumeSnapshotRenderer.addUsageCols(this.doc, volume.getSnapshotTotals(), units);
                        for (String snapId : volume.getSnapshotUsage().keySet()) {
                            VolumeSnapshotUsageArtEntity snap = volume.getSnapshotUsage().get(snapId);
                            this.doc.newRow().addValCol(volume.getVolumeId()).addValCol(snapId);
                            VolumeSnapshotRenderer.addUsageCols(this.doc, snap, units);
                        }
                    }
                }
            }
        }
        this.doc.tableClose();
        this.doc.close();
    }

    public static Document addUsageCols(Document doc, VolumeSnapshotUsageArtEntity entity, Units units) throws IOException {
        doc.addValCol(entity.getSnapshotNum());
        doc.addValCol(UnitUtil.convertSize(entity.getSizeGB(), SizeUnit.GB, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSizeTime(entity.getGBSecs(), SizeUnit.GB, units.getSizeUnit(), TimeUnit.SECS, units.getTimeUnit()));
        return doc;
    }
}

