/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeUsageArtEntity;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.UnitUtil;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

class VolumeRenderer
implements Renderer {
    private Document doc;

    public VolumeRenderer(Document doc) {
        this.doc = doc;
    }

    @Override
    public void render(ReportArtEntity report, OutputStream os, Units units) throws IOException {
        this.doc.setWriter(new OutputStreamWriter(os));
        this.doc.open();
        this.doc.textLine("Volume Report", 1);
        this.doc.textLine("Begin:" + new Date(report.getBeginMs()).toString(), 4);
        this.doc.textLine("End:" + new Date(report.getEndMs()).toString(), 4);
        this.doc.textLine("Resource Usage Section", 3);
        this.doc.tableOpen();
        this.doc.newRow().addValCol("Instance Id").addValCol("Volume Id").addValCol("# Vol").addValCol("Size (" + units.labelForSize() + ")").addValCol(units.labelForSizeTime());
        for (String zoneName : report.getZones().keySet()) {
            AvailabilityZoneArtEntity zone = report.getZones().get(zoneName);
            this.doc.newRow().addLabelCol(0, "Zone: " + zoneName).addValCol("cumul.").addValCol("cumul.");
            VolumeRenderer.addUsageCols(this.doc, zone.getUsageTotals().getVolumeTotals(), units);
            for (String accountName : zone.getAccounts().keySet()) {
                AccountArtEntity account = zone.getAccounts().get(accountName);
                this.doc.newRow().addLabelCol(1, "Account: " + accountName).addValCol("cumul.").addValCol("cumul.");
                VolumeRenderer.addUsageCols(this.doc, account.getUsageTotals().getVolumeTotals(), units);
                for (String userName : account.getUsers().keySet()) {
                    UserArtEntity user = account.getUsers().get(userName);
                    this.doc.newRow().addLabelCol(2, "User: " + userName).addValCol("cumul.").addValCol("cumul.");
                    VolumeRenderer.addUsageCols(this.doc, user.getUsageTotals().getVolumeTotals(), units);
                    for (String volumeUuid : user.getVolumes().keySet()) {
                        VolumeArtEntity volume = user.getVolumes().get(volumeUuid);
                        this.doc.newRow().addValCol("cumul.").addValCol(volume.getVolumeId());
                        VolumeRenderer.addUsageCols(this.doc, volume.getUsage(), units);
                        for (String instanceId : volume.getInstanceAttachments().keySet()) {
                            VolumeUsageArtEntity usage = volume.getInstanceAttachments().get(instanceId);
                            this.doc.newRow().addValCol(instanceId).addValCol(volume.getVolumeId());
                            VolumeRenderer.addUsageCols(this.doc, usage, units);
                        }
                    }
                }
            }
        }
        this.doc.tableClose();
        this.doc.close();
    }

    public static Document addUsageCols(Document doc, VolumeUsageArtEntity entity, Units units) throws IOException {
        doc.addValCol(entity.getVolumeCnt());
        doc.addValCol(UnitUtil.convertSize(entity.getSizeGB(), SizeUnit.GB, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSizeTime(entity.getGBSecs(), SizeUnit.GB, units.getSizeUnit(), TimeUnit.SECS, units.getTimeUnit()));
        return doc;
    }
}

