/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.BucketUsageArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.UnitUtil;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

class S3Renderer
implements Renderer {
    private Document doc;

    public S3Renderer(Document doc) {
        this.doc = doc;
    }

    @Override
    public void render(ReportArtEntity report, OutputStream os, Units units) throws IOException {
        this.doc.setWriter(new OutputStreamWriter(os));
        this.doc.setUnlabeledRowIndent(2);
        this.doc.open();
        this.doc.textLine("S3 Report", 1);
        this.doc.textLine("Begin:" + new Date(report.getBeginMs()).toString(), 4);
        this.doc.textLine("End:" + new Date(report.getEndMs()).toString(), 4);
        this.doc.textLine("Resource Usage Section", 3);
        this.doc.tableOpen();
        this.doc.newRow().addValCol("Bucket").addValCol("# Objects").addValCol("Total Size (" + units.labelForSize() + ")").addValCol("Obj " + units.labelForSizeTime());
        for (String accountName : report.getAccounts().keySet()) {
            AccountArtEntity account = report.getAccounts().get(accountName);
            this.doc.newRow().addLabelCol(0, "Account: " + accountName).addValCol("cumul.");
            S3Renderer.addUsageCols(this.doc, account.getUsageTotals().getBucketTotals(), units);
            for (String userName : account.getUsers().keySet()) {
                UserArtEntity user = account.getUsers().get(userName);
                this.doc.newRow().addLabelCol(1, "User: " + userName).addValCol("cumul.");
                S3Renderer.addUsageCols(this.doc, user.getUsageTotals().getBucketTotals(), units);
                for (String bucketName : user.getBucketUsage().keySet()) {
                    BucketUsageArtEntity usage = user.getBucketUsage().get(bucketName);
                    this.doc.newRow().addValCol(bucketName);
                    S3Renderer.addUsageCols(this.doc, usage, units);
                }
            }
        }
        this.doc.tableClose();
        this.doc.close();
    }

    public static Document addUsageCols(Document doc, BucketUsageArtEntity entity, Units units) throws IOException {
        doc.addValCol(entity.getObjectsNum());
        doc.addValCol(UnitUtil.convertSize(entity.getSize(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSizeTime(entity.getGBSecs(), SizeUnit.GB, units.getSizeUnit(), TimeUnit.SECS, units.getTimeUnit()));
        return doc;
    }
}

