/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.ReportFormat;
import com.eucalyptus.reporting.ReportType;
import com.eucalyptus.reporting.art.renderer.ComputeCapacityRenderer;
import com.eucalyptus.reporting.art.renderer.ElasticIpRenderer;
import com.eucalyptus.reporting.art.renderer.InstanceRenderer;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.S3Renderer;
import com.eucalyptus.reporting.art.renderer.VolumeRenderer;
import com.eucalyptus.reporting.art.renderer.VolumeSnapshotRenderer;
import com.eucalyptus.reporting.art.renderer.document.CsvDocument;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.art.renderer.document.HtmlDocument;

public class RendererFactory {
    public static Renderer getRenderer(ReportType type, ReportFormat format) {
        Document document;
        if (format.equals((Object)ReportFormat.CSV)) {
            document = new CsvDocument();
        } else if (format.equals((Object)ReportFormat.HTML)) {
            document = new HtmlDocument();
        } else {
            throw new UnsupportedOperationException("Unsupported format:" + (Object)((Object)format));
        }
        if (type.equals((Object)ReportType.INSTANCE)) {
            return new InstanceRenderer(document);
        }
        if (type.equals((Object)ReportType.VOLUME)) {
            return new VolumeRenderer(document);
        }
        if (type.equals((Object)ReportType.SNAPSHOT)) {
            return new VolumeSnapshotRenderer(document);
        }
        if (type.equals((Object)ReportType.ELASTIC_IP)) {
            return new ElasticIpRenderer(document);
        }
        if (type.equals((Object)ReportType.S3)) {
            return new S3Renderer(document);
        }
        if (type.equals((Object)ReportType.CAPACITY)) {
            return new ComputeCapacityRenderer(document);
        }
        throw new UnsupportedOperationException("Unsupported type:" + (Object)((Object)type));
    }
}

