/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceUsageArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.UnitUtil;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

class InstanceRenderer
implements Renderer {
    private final Document doc;

    public InstanceRenderer(Document doc) {
        this.doc = doc;
    }

    @Override
    public void render(ReportArtEntity report, OutputStream os, Units units) throws IOException {
        this.doc.setWriter(new OutputStreamWriter(os));
        this.doc.open();
        this.doc.textLine("Instance Report", 1);
        this.doc.textLine("Begin:" + new Date(report.getBeginMs()).toString(), 4);
        this.doc.textLine("End:" + new Date(report.getEndMs()).toString(), 4);
        this.doc.textLine("Resource Usage Section", 3);
        this.doc.tableOpen();
        this.doc.newRow().addEmptyValCols(5).addValCol("Net Total " + (Object)((Object)units.getSizeUnit()), 2, "center").addValCol("Net External " + (Object)((Object)units.getSizeUnit()), 2, "center").addValCol("Disk " + (Object)((Object)units.getSizeUnit()), 2, "center").addValCol("Disk IOPS (M)", 2, "center").addValCol("Disk Time (" + (Object)((Object)TimeUnit.values()[units.getTimeUnit().ordinal() - 1]) + ")", 2, "center");
        this.doc.newRow().addValCol("InstanceId").addValCol("Type").addValCol("#").addValCol(units.getTimeUnit().toString()).addValCol("CpuUsage%").addValCol("In").addValCol("Out").addValCol("In").addValCol("Out").addValCol("Read").addValCol("Write").addValCol("Read").addValCol("Write").addValCol("Read").addValCol("Write");
        for (String zoneName : report.getZones().keySet()) {
            AvailabilityZoneArtEntity zone = report.getZones().get(zoneName);
            this.doc.newRow().addLabelCol(0, "Zone: " + zoneName).addValCol("cumul.").addValCol("cumul.");
            InstanceRenderer.addUsageCols(this.doc, zone.getUsageTotals().getInstanceTotals(), units);
            for (String accountName : zone.getAccounts().keySet()) {
                AccountArtEntity account = zone.getAccounts().get(accountName);
                this.doc.newRow().addLabelCol(1, "Account: " + accountName).addValCol("cumul.").addValCol("cumul.");
                InstanceRenderer.addUsageCols(this.doc, account.getUsageTotals().getInstanceTotals(), units);
                for (String userName : account.getUsers().keySet()) {
                    UserArtEntity user = account.getUsers().get(userName);
                    this.doc.newRow().addLabelCol(2, "User: " + userName).addValCol("cumul.").addValCol("cumul.");
                    InstanceRenderer.addUsageCols(this.doc, user.getUsageTotals().getInstanceTotals(), units);
                    for (String instanceUuid : user.getInstances().keySet()) {
                        InstanceArtEntity instance = user.getInstances().get(instanceUuid);
                        this.doc.newRow().addValCol(instance.getInstanceId()).addValCol(instance.getInstanceType());
                        InstanceRenderer.addUsageCols(this.doc, instance.getUsage(), units);
                    }
                }
            }
        }
        this.doc.tableClose();
        this.doc.close();
    }

    public static Document addUsageCols(Document doc, InstanceUsageArtEntity entity, Units units) throws IOException {
        doc.addValCol(Long.valueOf(entity.getInstanceCnt()));
        doc.addValCol(UnitUtil.convertTime(entity.getDurationMs(), TimeUnit.MS, units.getTimeUnit()));
        if (entity.getDurationMs() > 0L) {
            doc.addValCol(entity.getCpuUtilizationMs() == null ? 0.0 : 100.0 * (double)entity.getCpuUtilizationMs().longValue() / (double)entity.getDurationMs());
        } else {
            doc.addValCol(0.0);
        }
        doc.addValCol(UnitUtil.convertSize(entity.getNetTotalInBytes(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSize(entity.getNetTotalOutBytes(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSize(entity.getNetExternalInBytes(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSize(entity.getNetExternalOutBytes(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSize(entity.getDiskReadBytes(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(UnitUtil.convertSize(entity.getDiskWriteBytes(), SizeUnit.B, units.getSizeUnit()));
        doc.addValCol(entity.getDiskReadOps() == null ? null : Double.valueOf((double)entity.getDiskReadOps().longValue() / 1000000.0));
        doc.addValCol(entity.getDiskWriteOps() == null ? null : Double.valueOf((double)entity.getDiskWriteOps().longValue() / 1000000.0));
        doc.addValCol(UnitUtil.convertTime(entity.getDiskReadTime(), TimeUnit.MS, TimeUnit.values()[units.getTimeUnit().ordinal() - 1]));
        doc.addValCol(UnitUtil.convertTime(entity.getDiskWriteTime(), TimeUnit.MS, TimeUnit.values()[units.getTimeUnit().ordinal() - 1]));
        return doc;
    }
}

