/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.ElasticIpArtEntity;
import com.eucalyptus.reporting.art.entity.ElasticIpUsageArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.UnitUtil;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;

class ElasticIpRenderer
implements Renderer {
    private Document doc;

    public ElasticIpRenderer(Document doc) {
        this.doc = doc;
    }

    @Override
    public void render(ReportArtEntity report, OutputStream os, Units units) throws IOException {
        this.doc.setWriter(new OutputStreamWriter(os));
        this.doc.setUnlabeledRowIndent(2);
        this.doc.open();
        this.doc.textLine("Elastic IP Report", 1);
        this.doc.textLine("Begin:" + new Date(report.getBeginMs()).toString(), 4);
        this.doc.textLine("End:" + new Date(report.getEndMs()).toString(), 4);
        this.doc.textLine("Resource Usage Section", 3);
        this.doc.tableOpen();
        this.doc.newRow().addValCol("Elastic IP").addValCol("Instance ID").addValCol("# IPs").addValCol("Duration (" + units.labelForTime() + ")");
        for (String accountName : report.getAccounts().keySet()) {
            AccountArtEntity account = report.getAccounts().get(accountName);
            this.doc.newRow().addLabelCol(0, "Account: " + accountName).addValCol("cumul.").addValCol("cumul.");
            ElasticIpRenderer.addUsageCols(this.doc, account.getUsageTotals().getElasticIpTotals(), units);
            for (String userName : account.getUsers().keySet()) {
                UserArtEntity user = account.getUsers().get(userName);
                this.doc.newRow().addLabelCol(1, "User: " + userName).addValCol("cumul.").addValCol("cumul.");
                ElasticIpRenderer.addUsageCols(this.doc, user.getUsageTotals().getElasticIpTotals(), units);
                for (String ip : user.getElasticIps().keySet()) {
                    ElasticIpArtEntity elasticIp = user.getElasticIps().get(ip);
                    this.doc.newRow().addValCol(ip).addValCol("cumul.");
                    ElasticIpRenderer.addUsageCols(this.doc, elasticIp.getUsage(), units);
                    for (String instanceId : elasticIp.getInstanceAttachments().keySet()) {
                        ElasticIpUsageArtEntity usage = elasticIp.getInstanceAttachments().get(instanceId);
                        this.doc.newRow().addValCol(ip).addValCol(instanceId);
                        ElasticIpRenderer.addUsageCols(this.doc, usage, units);
                    }
                }
            }
        }
        this.doc.tableClose();
        this.doc.close();
    }

    public static Document addUsageCols(Document doc, ElasticIpUsageArtEntity entity, Units units) throws IOException {
        doc.addValCol(entity.getIpNum());
        doc.addValCol(UnitUtil.convertTime(entity.getDurationMs(), TimeUnit.MS, units.getTimeUnit()));
        return doc;
    }
}

