/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.renderer;

import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.ComputeCapacityArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.renderer.Renderer;
import com.eucalyptus.reporting.art.renderer.document.Document;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Map;
import java.util.Set;

class ComputeCapacityRenderer
implements Renderer {
    private final Document doc;

    public ComputeCapacityRenderer(Document doc) {
        this.doc = doc;
    }

    @Override
    public void render(ReportArtEntity report, OutputStream os, Units units) throws IOException {
        this.doc.setWriter(new OutputStreamWriter(os));
        this.doc.setUnlabeledRowIndent(2);
        this.doc.open();
        this.doc.textLine("Capacity Report", 1);
        this.doc.textLine("Begin:" + new Date(report.getBeginMs()).toString(), 4);
        this.doc.textLine("End:" + new Date(report.getEndMs()).toString(), 4);
        this.doc.textLine("Resource Usage Section", 3);
        this.doc.tableOpen();
        this.doc.newRow().addValCol("Resource").addValCol("Available").addValCol("Total");
        this.doc.newRow().addLabelCol(0, "Cloud");
        ComputeCapacityArtEntity entity = report.getUsageTotals().getComputeCapacityArtEntity();
        this.doc.addValCol("S3 Storage").addValCol(entity.getSizeS3ObjectAvailableGB()).addValCol(entity.getSizeS3ObjectTotalGB()).newRow();
        this.doc.addValCol("Elastic IP").addValCol(entity.getNumPublicIpsAvailable()).addValCol(entity.getNumPublicIpsTotal()).newRow();
        this.outputZoneCapacities(entity);
        for (Map.Entry<String, AvailabilityZoneArtEntity> azEntry : report.getZones().entrySet()) {
            ComputeCapacityArtEntity zoneEntity = azEntry.getValue().getUsageTotals().getComputeCapacityArtEntity();
            this.doc.addLabelCol(0, "Availability Zone: " + azEntry.getKey());
            this.outputZoneCapacities(zoneEntity);
        }
        this.doc.tableClose();
        this.doc.close();
    }

    private void outputZoneCapacities(ComputeCapacityArtEntity entity) throws IOException {
        this.doc.addValCol("EBS Storage").addValCol(entity.getSizeEbsAvailableGB()).addValCol(entity.getSizeEbsTotalGB()).newRow();
        this.doc.addValCol("EC2 Compute").addValCol(entity.getEc2ComputeUnitsAvailable()).addValCol(entity.getEc2ComputeUnitsTotal()).newRow();
        this.doc.addValCol("EC2 Disk").addValCol(entity.getEc2DiskUnitsAvailable()).addValCol(entity.getEc2DiskUnitsTotal()).newRow();
        this.doc.addValCol("EC2 Memory").addValCol(entity.getEc2MemoryUnitsAvailable()).addValCol(entity.getEc2MemoryUnitsTotal()).newRow();
        Set<String> vmTypes = entity.getVmTypes();
        if (!vmTypes.isEmpty()) {
            this.doc.addLabelCol(1, "VM Types");
            for (String vmType : vmTypes) {
                this.doc.addValCol(vmType).addValCol(entity.getInstancesAvailableForType(vmType)).addValCol(entity.getInstancesTotalForType(vmType)).newRow();
            }
        }
    }
}

