/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeSnapshotUsageArtEntity;
import com.eucalyptus.reporting.art.generator.AbstractArtGenerator;
import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingAccountDao;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.domain.ReportingUserDao;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotDeleteEvent;
import com.google.common.base.Predicate;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class VolumeSnapshotArtGenerator
extends AbstractArtGenerator {
    private static Logger log = Logger.getLogger(VolumeSnapshotArtGenerator.class);

    @Override
    public ReportArtEntity generateReportArt(final ReportArtEntity report) {
        log.debug((Object)"GENERATING REPORT ART");
        final HashMap snapshotEndTimes = new HashMap();
        this.foreachReportingSnapshotDeleteEvent(report.getEndMs(), new Predicate<ReportingVolumeSnapshotDeleteEvent>(){

            public boolean apply(ReportingVolumeSnapshotDeleteEvent deleteEvent) {
                snapshotEndTimes.put(deleteEvent.getUuid(), deleteEvent.getTimestampMs());
                return true;
            }
        });
        final HashMap volumeCreateEvents = new HashMap();
        this.foreachReportingVolumeCreateEvent(report.getEndMs(), new Predicate<ReportingVolumeCreateEvent>(){

            public boolean apply(ReportingVolumeCreateEvent createEvent) {
                volumeCreateEvents.put(createEvent.getUuid(), createEvent);
                return true;
            }
        });
        this.foreachReportingSnapshotCreateEvent(report.getEndMs(), new Predicate<ReportingVolumeSnapshotCreateEvent>(){

            public boolean apply(ReportingVolumeSnapshotCreateEvent createEvent) {
                long endTime;
                long l = endTime = snapshotEndTimes.containsKey(createEvent.getUuid()) ? ((Long)snapshotEndTimes.get(createEvent.getUuid())).longValue() : report.getEndMs();
                if (createEvent.getTimestampMs() <= report.getEndMs() && endTime >= report.getBeginMs() && volumeCreateEvents.containsKey(createEvent.getVolumeUuid())) {
                    VolumeSnapshotUsageArtEntity usage = new VolumeSnapshotUsageArtEntity();
                    usage.setSizeGB(createEvent.getSizeGB());
                    usage.setSnapshotNum(1L);
                    long durationMs = Math.min(report.getEndMs(), endTime) - Math.max(report.getBeginMs(), createEvent.getTimestampMs());
                    usage.setGBSecs(createEvent.getSizeGB() * (durationMs / 1000L));
                    VolumeArtEntity vol = VolumeSnapshotArtGenerator.addParentNodes(report, (ReportingVolumeCreateEvent)volumeCreateEvents.get(createEvent.getVolumeUuid()));
                    vol.getSnapshotUsage().put(createEvent.getVolumeSnapshotId(), usage);
                }
                return true;
            }
        });
        for (String zoneName : report.getZones().keySet()) {
            AvailabilityZoneArtEntity zone = report.getZones().get(zoneName);
            for (String accountName : zone.getAccounts().keySet()) {
                AccountArtEntity account = zone.getAccounts().get(accountName);
                for (String userName : account.getUsers().keySet()) {
                    UserArtEntity user = account.getUsers().get(userName);
                    for (String volumeUuid : user.getVolumes().keySet()) {
                        VolumeArtEntity volume = user.getVolumes().get(volumeUuid);
                        for (String snapId : volume.getSnapshotUsage().keySet()) {
                            VolumeSnapshotUsageArtEntity snap = volume.getSnapshotUsage().get(snapId);
                            VolumeSnapshotArtGenerator.updateUsageTotals(volume.getSnapshotTotals(), snap);
                            VolumeSnapshotArtGenerator.updateUsageTotals(user.getUsageTotals().getSnapshotTotals(), snap);
                            VolumeSnapshotArtGenerator.updateUsageTotals(account.getUsageTotals().getSnapshotTotals(), snap);
                            VolumeSnapshotArtGenerator.updateUsageTotals(zone.getUsageTotals().getSnapshotTotals(), snap);
                        }
                    }
                }
            }
        }
        return report;
    }

    private static VolumeArtEntity addParentNodes(ReportArtEntity report, ReportingVolumeCreateEvent createEvent) {
        UserArtEntity user;
        AccountArtEntity account;
        ReportingAccount reportingAccount;
        if (!report.getZones().containsKey(createEvent.getAvailabilityZone())) {
            report.getZones().put(createEvent.getAvailabilityZone(), new AvailabilityZoneArtEntity());
        }
        AvailabilityZoneArtEntity zone = report.getZones().get(createEvent.getAvailabilityZone());
        ReportingUser reportingUser = ReportingUserDao.getInstance().getReportingUser(createEvent.getUserId());
        if (reportingUser == null) {
            log.error((Object)("No user corresponding to event:" + createEvent.getUserId()));
        }
        if ((reportingAccount = ReportingAccountDao.getInstance().getReportingAccount(reportingUser.getAccountId())) == null) {
            log.error((Object)("No account corresponding to user:" + reportingUser.getAccountId()));
        }
        if (!zone.getAccounts().containsKey(reportingAccount.getName())) {
            zone.getAccounts().put(reportingAccount.getName(), new AccountArtEntity());
        }
        if (!(account = zone.getAccounts().get(reportingAccount.getName())).getUsers().containsKey(reportingUser.getName())) {
            account.getUsers().put(reportingUser.getName(), new UserArtEntity());
        }
        if (!(user = account.getUsers().get(reportingUser.getName())).getVolumes().containsKey(createEvent.getUuid())) {
            user.getVolumes().put(createEvent.getUuid(), new VolumeArtEntity(createEvent.getVolumeId()));
        }
        return user.getVolumes().get(createEvent.getUuid());
    }

    private static void updateUsageTotals(VolumeSnapshotUsageArtEntity totalEntity, VolumeSnapshotUsageArtEntity newEntity) {
        totalEntity.setSnapshotNum(newEntity.getSnapshotNum() + totalEntity.getSnapshotNum());
        totalEntity.setGBSecs(totalEntity.getGBSecs() + newEntity.getGBSecs());
        totalEntity.setSizeGB(VolumeSnapshotArtGenerator.plus(totalEntity.getSizeGB(), newEntity.getSizeGB()));
    }

    private static Long plus(Long added, Long defaultVal) {
        if (added == null) {
            return defaultVal;
        }
        if (defaultVal == null) {
            return added;
        }
        return added + defaultVal;
    }

    protected void foreachReportingVolumeCreateEvent(long endExclusive, Predicate<ReportingVolumeCreateEvent> callback) {
        this.foreach(ReportingVolumeCreateEvent.class, this.before(endExclusive), true, callback);
    }

    protected void foreachReportingSnapshotCreateEvent(long endExclusive, Predicate<ReportingVolumeSnapshotCreateEvent> callback) {
        this.foreach(ReportingVolumeSnapshotCreateEvent.class, this.before(endExclusive), true, callback);
    }

    protected void foreachReportingSnapshotDeleteEvent(long endExclusive, Predicate<ReportingVolumeSnapshotDeleteEvent> callback) {
        this.foreach(ReportingVolumeSnapshotDeleteEvent.class, this.before(endExclusive), true, callback);
    }
}

