/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeUsageArtEntity;
import com.eucalyptus.reporting.art.generator.AbstractArtGenerator;
import com.eucalyptus.reporting.art.util.AttachDurationCalculator;
import com.eucalyptus.reporting.art.util.DurationCalculator;
import com.eucalyptus.reporting.art.util.StartEndTimes;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDetachEvent;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class VolumeArtGenerator
extends AbstractArtGenerator {
    private static Logger log = Logger.getLogger(VolumeArtGenerator.class);

    @Override
    public ReportArtEntity generateReportArt(final ReportArtEntity report) {
        log.debug((Object)"Generating report ART");
        final HashMap reportingUsersById = Maps.newHashMap();
        final HashMap accountNamesById = Maps.newHashMap();
        final HashMap volumeEntities = Maps.newHashMap();
        final HashMap volStartEndTimes = Maps.newHashMap();
        this.foreachReportingVolumeCreateEvent(report.getEndMs(), new Predicate<ReportingVolumeCreateEvent>(){

            public boolean apply(ReportingVolumeCreateEvent createEvent) {
                AccountArtEntity account;
                if (!report.getZones().containsKey(createEvent.getAvailabilityZone())) {
                    report.getZones().put(createEvent.getAvailabilityZone(), new AvailabilityZoneArtEntity());
                }
                AvailabilityZoneArtEntity zone = report.getZones().get(createEvent.getAvailabilityZone());
                ReportingUser reportingUser = VolumeArtGenerator.this.getUserById(reportingUsersById, createEvent.getUserId());
                if (reportingUser == null) {
                    log.error((Object)("No user corresponding to event:" + createEvent.getUserId()));
                    return true;
                }
                String accountName = VolumeArtGenerator.this.getAccountNameById(accountNamesById, reportingUser.getAccountId());
                if (accountName == null) {
                    log.error((Object)("No account corresponding to user:" + reportingUser.getAccountId()));
                    return true;
                }
                if (!zone.getAccounts().containsKey(accountName)) {
                    zone.getAccounts().put(accountName, new AccountArtEntity());
                }
                if (!(account = zone.getAccounts().get(accountName)).getUsers().containsKey(reportingUser.getName())) {
                    account.getUsers().put(reportingUser.getName(), new UserArtEntity());
                }
                UserArtEntity user = account.getUsers().get(reportingUser.getName());
                VolumeArtEntity volume = new VolumeArtEntity(createEvent.getVolumeId());
                volume.getUsage().setSizeGB(createEvent.getSizeGB());
                long startTime = createEvent.getTimestampMs();
                if (startTime <= report.getEndMs()) {
                    user.getVolumes().put(createEvent.getUuid(), volume);
                    volStartEndTimes.put(createEvent.getUuid(), new StartEndTimes(startTime, report.getEndMs()));
                    volumeEntities.put(createEvent.getUuid(), volume);
                    volume.getUsage().setVolumeCnt(1L);
                }
                return true;
            }
        });
        this.foreachReportingVolumeDeleteEvent(report.getEndMs(), new Predicate<ReportingVolumeDeleteEvent>(){

            public boolean apply(ReportingVolumeDeleteEvent deleteEvent) {
                long endTime = deleteEvent.getTimestampMs();
                if (endTime >= report.getBeginMs() && volStartEndTimes.containsKey(deleteEvent.getUuid())) {
                    StartEndTimes startEndTimes = (StartEndTimes)volStartEndTimes.get(deleteEvent.getUuid());
                    startEndTimes.setEndTime(endTime);
                } else {
                    volumeEntities.remove(deleteEvent.getUuid());
                    volStartEndTimes.remove(deleteEvent.getUuid());
                }
                return true;
            }
        });
        for (String uuid : volumeEntities.keySet()) {
            VolumeArtEntity volume = (VolumeArtEntity)volumeEntities.get(uuid);
            StartEndTimes startEndTimes = (StartEndTimes)volStartEndTimes.get(uuid);
            if (uuid == null) {
                log.error((Object)("volume without corresponding start end times:" + uuid));
                continue;
            }
            long duration = DurationCalculator.boundDuration(report.getBeginMs(), report.getEndMs(), startEndTimes.getStartTime(), startEndTimes.getEndTime()) / 1000L;
            volume.getUsage().setGBSecs(duration * volume.getUsage().getSizeGB());
        }
        final HashMap instanceEntities = new HashMap();
        this.foreachInstanceCreateEvent(report.getEndMs(), (Predicate<? super ReportingInstanceCreateEvent>)new Predicate<ReportingInstanceCreateEvent>(){

            public boolean apply(ReportingInstanceCreateEvent createEvent) {
                InstanceArtEntity instance = new InstanceArtEntity(createEvent.getInstanceType(), createEvent.getInstanceId());
                instanceEntities.put(createEvent.getUuid(), instance);
                return true;
            }
        });
        final AttachDurationCalculator durationCalc = new AttachDurationCalculator(report.getBeginMs(), report.getEndMs());
        this.foreachReportingVolumeDetachEvent(report.getEndMs(), new Predicate<ReportingVolumeDetachEvent>(){

            public boolean apply(ReportingVolumeDetachEvent detachEvent) {
                durationCalc.detach(detachEvent.getInstanceUuid(), detachEvent.getVolumeUuid(), detachEvent.getTimestampMs());
                return true;
            }
        });
        this.foreachReportingVolumeAttachEvent(report.getEndMs(), new Predicate<ReportingVolumeAttachEvent>(){

            public boolean apply(ReportingVolumeAttachEvent attachEvent) {
                long durationMs = durationCalc.attach(attachEvent.getInstanceUuid(), attachEvent.getVolumeUuid(), attachEvent.getTimestampMs());
                if (durationMs == 0L) {
                    return true;
                }
                if (!volumeEntities.containsKey(attachEvent.getVolumeUuid())) {
                    return true;
                }
                VolumeArtEntity volume = (VolumeArtEntity)volumeEntities.get(attachEvent.getVolumeUuid());
                long gbsecs = durationMs / 1000L * volume.getUsage().getSizeGB();
                if (volume.getInstanceAttachments().containsKey(attachEvent.getInstanceUuid())) {
                    gbsecs += volume.getInstanceAttachments().get(attachEvent.getInstanceUuid()).getGBSecs();
                }
                VolumeUsageArtEntity usage = new VolumeUsageArtEntity();
                usage.setGBSecs(gbsecs);
                usage.setSizeGB(volume.getUsage().getSizeGB());
                usage.setVolumeCnt(1L);
                if (instanceEntities.keySet().contains(attachEvent.getInstanceUuid())) {
                    String instanceId = ((InstanceArtEntity)instanceEntities.get(attachEvent.getInstanceUuid())).getInstanceId();
                    volume.getInstanceAttachments().put(instanceId, usage);
                } else {
                    log.error((Object)("instance uuid in attach events without corresponding instance:" + attachEvent.getInstanceUuid()));
                }
                return true;
            }
        });
        for (String zoneName : report.getZones().keySet()) {
            AvailabilityZoneArtEntity zone = report.getZones().get(zoneName);
            for (String accountName : zone.getAccounts().keySet()) {
                AccountArtEntity account = zone.getAccounts().get(accountName);
                for (String userName : account.getUsers().keySet()) {
                    UserArtEntity user = account.getUsers().get(userName);
                    for (String volumeUuid : user.getVolumes().keySet()) {
                        VolumeArtEntity volume = user.getVolumes().get(volumeUuid);
                        VolumeArtGenerator.updateUsageTotals(user.getUsageTotals().getVolumeTotals(), volume.getUsage());
                        VolumeArtGenerator.updateUsageTotals(account.getUsageTotals().getVolumeTotals(), volume.getUsage());
                        VolumeArtGenerator.updateUsageTotals(zone.getUsageTotals().getVolumeTotals(), volume.getUsage());
                    }
                }
            }
        }
        return report;
    }

    protected void foreachReportingVolumeCreateEvent(long endExclusive, Predicate<ReportingVolumeCreateEvent> callback) {
        this.foreach(ReportingVolumeCreateEvent.class, this.before(endExclusive), true, this.validateCreate(callback));
    }

    protected void foreachReportingVolumeDeleteEvent(long endExclusive, Predicate<ReportingVolumeDeleteEvent> callback) {
        this.foreach(ReportingVolumeDeleteEvent.class, this.before(endExclusive), true, this.validateDelete(callback));
    }

    protected void foreachReportingVolumeAttachEvent(long endExclusive, Predicate<ReportingVolumeAttachEvent> callback) {
        this.foreach(ReportingVolumeAttachEvent.class, this.before(endExclusive), true, this.validateAttach(callback));
    }

    protected void foreachReportingVolumeDetachEvent(long endExclusive, Predicate<ReportingVolumeDetachEvent> callback) {
        this.foreach(ReportingVolumeDetachEvent.class, this.before(endExclusive), true, this.validateDetach(callback));
    }

    protected void foreachInstanceCreateEvent(long endExclusive, Predicate<? super ReportingInstanceCreateEvent> callback) {
        this.foreach(ReportingInstanceCreateEvent.class, this.before(endExclusive), true, callback);
    }

    private Predicate<ReportingVolumeCreateEvent> validateCreate(final Predicate<? super ReportingVolumeCreateEvent> callback) {
        return new Predicate<ReportingVolumeCreateEvent>(){

            public boolean apply(ReportingVolumeCreateEvent event) {
                if (event == null || event.getAvailabilityZone() == null || event.getVolumeId() == null || event.getSizeGB() == null || event.getUserId() == null || event.getUuid() == null || event.getTimestampMs() == null) {
                    log.debug((Object)("Ignoring invalid create event: " + event));
                    return true;
                }
                return callback.apply((Object)event);
            }
        };
    }

    private Predicate<ReportingVolumeDeleteEvent> validateDelete(final Predicate<? super ReportingVolumeDeleteEvent> callback) {
        return new Predicate<ReportingVolumeDeleteEvent>(){

            public boolean apply(ReportingVolumeDeleteEvent event) {
                if (event == null || event.getUuid() == null || event.getTimestampMs() == null) {
                    log.debug((Object)("Ignoring invalid delete event: " + event));
                    return true;
                }
                return callback.apply((Object)event);
            }
        };
    }

    private Predicate<ReportingVolumeAttachEvent> validateAttach(final Predicate<? super ReportingVolumeAttachEvent> callback) {
        return new Predicate<ReportingVolumeAttachEvent>(){

            public boolean apply(ReportingVolumeAttachEvent event) {
                if (event == null || event.getVolumeUuid() == null || event.getInstanceUuid() == null || event.getSizeGB() == null || event.getTimestampMs() == null) {
                    log.debug((Object)("Ignoring invalid attach event: " + event));
                    return true;
                }
                return callback.apply((Object)event);
            }
        };
    }

    private Predicate<ReportingVolumeDetachEvent> validateDetach(final Predicate<? super ReportingVolumeDetachEvent> callback) {
        return new Predicate<ReportingVolumeDetachEvent>(){

            public boolean apply(ReportingVolumeDetachEvent event) {
                if (event == null || event.getVolumeUuid() == null || event.getInstanceUuid() == null || event.getTimestampMs() == null) {
                    log.debug((Object)("Ignoring invalid detach event: " + event));
                    return true;
                }
                return callback.apply((Object)event);
            }
        };
    }

    private static void updateUsageTotals(VolumeUsageArtEntity totalEntity, VolumeUsageArtEntity newEntity) {
        totalEntity.setGBSecs(totalEntity.getGBSecs() + newEntity.getGBSecs());
        totalEntity.setVolumeCnt(totalEntity.getVolumeCnt() + 1L);
        totalEntity.setSizeGB(VolumeArtGenerator.plus(totalEntity.getSizeGB(), newEntity.getSizeGB()));
    }

    private static Long plus(Long added, Long defaultVal) {
        if (added == null) {
            return defaultVal;
        }
        if (defaultVal == null) {
            return added;
        }
        return added + defaultVal;
    }
}

