/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.BucketUsageArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.generator.AbstractArtGenerator;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectDeleteEvent;
import com.eucalyptus.reporting.units.SizeUnit;
import com.eucalyptus.reporting.units.TimeUnit;
import com.eucalyptus.reporting.units.UnitUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class S3ArtGenerator
extends AbstractArtGenerator {
    private static Logger log = Logger.getLogger(S3ArtGenerator.class);

    @Override
    public ReportArtEntity generateReportArt(final ReportArtEntity report) {
        log.debug((Object)"Generating S3 report ART");
        final HashMap endTimesMap = Maps.newHashMap();
        this.foreachReportingS3ObjectDeleteEvent(report.getEndMs(), this.buildTimestampMap(report, endTimesMap, this.key()));
        final HashMap users = Maps.newHashMap();
        final HashMap accounts = Maps.newHashMap();
        final HashMap bucketObjectData = Maps.newHashMap();
        this.foreachReportingS3ObjectCreateEvent(report.getEndMs(), new Predicate<ReportingS3ObjectCreateEvent>(){

            public boolean apply(ReportingS3ObjectCreateEvent createEvent) {
                UserArtEntity user;
                AccountArtEntity account;
                S3ObjectKey objectKey = new S3ObjectKey(createEvent.getS3BucketName(), createEvent.getS3ObjectKey(), createEvent.getObjectVersion());
                Long objectEndTime = Math.min(S3ArtGenerator.this.findTimeAfter(endTimesMap, objectKey, createEvent.getTimestampMs()), report.getEndMs());
                if (objectEndTime < report.getBeginMs()) {
                    return true;
                }
                ReportingUser reportingUser = S3ArtGenerator.this.getUserById(users, createEvent.getUserId());
                if (reportingUser == null) {
                    log.error((Object)("No user corresponding to event:" + createEvent.getUserId()));
                    return true;
                }
                String accountName = S3ArtGenerator.this.getAccountNameById(accounts, reportingUser.getAccountId());
                if (accountName == null) {
                    log.error((Object)("No account corresponding to user:" + reportingUser.getAccountId()));
                    return true;
                }
                if (!report.getAccounts().containsKey(accountName)) {
                    report.getAccounts().put(accountName, new AccountArtEntity());
                }
                if (!(account = report.getAccounts().get(accountName)).getUsers().containsKey(reportingUser.getName())) {
                    account.getUsers().put(reportingUser.getName(), new UserArtEntity());
                }
                if (!(user = account.getUsers().get(reportingUser.getName())).getBucketUsage().containsKey(createEvent.getS3BucketName())) {
                    user.getBucketUsage().put(createEvent.getS3BucketName(), new BucketUsageArtEntity());
                }
                BucketUsageArtEntity bucketUsage = user.getBucketUsage().get(createEvent.getS3BucketName());
                S3ObjectData data = new S3ObjectData(createEvent.getSize(), objectEndTime - Math.max(createEvent.getTimestampMs(), report.getBeginMs()));
                List bucketUserData = (List)bucketObjectData.get(bucketUsage);
                if (bucketUserData == null) {
                    bucketUserData = Lists.newLinkedList();
                    bucketObjectData.put(bucketUsage, bucketUserData);
                }
                bucketUserData.add(data);
                return true;
            }
        });
        for (String accountName : report.getAccounts().keySet()) {
            AccountArtEntity account = report.getAccounts().get(accountName);
            for (String userName : account.getUsers().keySet()) {
                UserArtEntity user = account.getUsers().get(userName);
                for (String bucketName : user.getBucketUsage().keySet()) {
                    BucketUsageArtEntity usage = user.getBucketUsage().get(bucketName);
                    List objectUsages = (List)bucketObjectData.get(usage);
                    if (objectUsages == null) {
                        log.error((Object)"Missing object usage for bucket");
                        continue;
                    }
                    usage.setObjectsNum(objectUsages.size());
                    long size = 0L;
                    long KBSecs = 0L;
                    for (S3ObjectData data : objectUsages) {
                        size += data.size;
                        KBSecs += data.durationMs / 1000L * UnitUtil.convertSize(data.size, SizeUnit.B, SizeUnit.KB);
                    }
                    long gBSecs = UnitUtil.convertSizeTime(KBSecs, SizeUnit.KB, SizeUnit.GB, TimeUnit.SECS, TimeUnit.SECS);
                    usage.setGBSecs(gBSecs);
                    usage.setSize(size);
                    S3ArtGenerator.updateUsageTotals(user.getUsageTotals().getBucketTotals(), usage);
                    S3ArtGenerator.updateUsageTotals(account.getUsageTotals().getBucketTotals(), usage);
                }
            }
        }
        return report;
    }

    private static void updateUsageTotals(BucketUsageArtEntity totalEntity, BucketUsageArtEntity newEntity) {
        totalEntity.setObjectsNum(totalEntity.getObjectsNum() + newEntity.getObjectsNum());
        totalEntity.setSize(totalEntity.getSize() + newEntity.getSize());
        totalEntity.setGBSecs(totalEntity.getGBSecs() + newEntity.getGBSecs());
    }

    private Function<ReportingS3ObjectDeleteEvent, S3ObjectKey> key() {
        return new Function<ReportingS3ObjectDeleteEvent, S3ObjectKey>(){

            public S3ObjectKey apply(ReportingS3ObjectDeleteEvent reportingEventSupport) {
                return new S3ObjectKey(reportingEventSupport.getS3BucketName(), reportingEventSupport.getS3ObjectKey(), reportingEventSupport.getObjectVersion());
            }
        };
    }

    protected void foreachReportingS3ObjectCreateEvent(long endExclusive, Predicate<ReportingS3ObjectCreateEvent> callback) {
        this.foreach(ReportingS3ObjectCreateEvent.class, this.before(endExclusive), true, callback);
    }

    protected void foreachReportingS3ObjectDeleteEvent(long endExclusive, Predicate<ReportingS3ObjectDeleteEvent> callback) {
        this.foreach(ReportingS3ObjectDeleteEvent.class, this.before(endExclusive), true, callback);
    }

    private static class S3ObjectData {
        private final long durationMs;
        private final long size;

        private S3ObjectData(long size, long durationMs) {
            this.durationMs = durationMs;
            this.size = size;
        }
    }

    private class S3ObjectKey {
        private final String bucketName;
        private final String objectKey;
        private final String objectVer;

        private S3ObjectKey(String bucketName, String objectKey, String objectVer) {
            this.bucketName = bucketName;
            this.objectKey = objectKey;
            this.objectVer = objectVer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.bucketName == null ? 0 : this.bucketName.hashCode());
            result = 31 * result + (this.objectKey == null ? 0 : this.objectKey.hashCode());
            result = 31 * result + (this.objectVer == null ? 0 : this.objectVer.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            S3ObjectKey other = (S3ObjectKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.bucketName == null ? other.bucketName != null : !this.bucketName.equals(other.bucketName)) {
                return false;
            }
            if (this.objectKey == null ? other.objectKey != null : !this.objectKey.equals(other.objectKey)) {
                return false;
            }
            return !(this.objectVer == null ? other.objectVer != null : !this.objectVer.equals(other.objectVer));
        }

        private S3ArtGenerator getOuterType() {
            return S3ArtGenerator.this;
        }
    }
}

