/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceUsageArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UsageTotalsArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.generator.AbstractArtGenerator;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingInstanceUsageEvent;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class InstanceArtGenerator
extends AbstractArtGenerator {
    private static Logger log = Logger.getLogger(InstanceArtGenerator.class);
    public static final String METRIC_NET_IN_BYTES = "NetworkIn";
    public static final String METRIC_NET_OUT_BYTES = "NetworkOut";
    public static final String METRIC_NET_EXT_IN_BYTES = "NetworkInExternal";
    public static final String METRIC_NET_EXT_OUT_BYTES = "NetworkOutExternal";
    public static final String METRIC_DISK_IN_BYTES = "DiskReadBytes";
    public static final String METRIC_DISK_OUT_BYTES = "DiskWriteBytes";
    public static final String METRIC_DISK_READ_OPS = "DiskReadOps";
    public static final String METRIC_DISK_WRITE_OPS = "DiskWriteOps";
    public static final String METRIC_CPU_USAGE_MS = "CPUUtilization";
    public static final String METRIC_VOLUME_READ = "VolumeTotalReadTime";
    public static final String METRIC_VOLUME_WRITE = "VolumeTotalWriteTime";
    public static final String DIM_TOTAL = "total";
    public static final String DIM_DEFAULT = "default";
    public static final String DIM_EXTERNAL = "external";
    private static final long USAGE_SEARCH_PERIOD = TimeUnit.DAYS.toMillis(12L);

    @Override
    public ReportArtEntity generateReportArt(final ReportArtEntity report) {
        log.debug((Object)"Generating report ART");
        final HashMap createEvents = Maps.newHashMap();
        this.foreachInstanceCreateEvent(report.getEndMs(), (Predicate<? super ReportingInstanceCreateEvent>)new Predicate<ReportingInstanceCreateEvent>(){

            public boolean apply(ReportingInstanceCreateEvent createEvent) {
                ReportingInstanceCreateEvent prevEvent = createEvents.put(createEvent.getUuid(), createEvent);
                if (prevEvent != null && prevEvent.getTimestampMs() < createEvent.getTimestampMs()) {
                    createEvents.put(prevEvent.getUuid(), prevEvent);
                }
                return true;
            }
        });
        final HashMap prevDataMap = Maps.newHashMap();
        final HashMap usageEntities = Maps.newHashMap();
        this.foreachInstanceUsageEvent(report.getBeginMs() - USAGE_SEARCH_PERIOD, report.getEndMs() + USAGE_SEARCH_PERIOD, (Predicate<? super ReportingInstanceUsageEvent>)new Predicate<ReportingInstanceUsageEvent>(){

            public boolean apply(ReportingInstanceUsageEvent event) {
                InstanceMetricDimensionKey key = new InstanceMetricDimensionKey(event.getUuid(), event.getMetric(), event.getDimension());
                long eventMs = event.getTimestampMs();
                if (event.getValue() == null) {
                    return true;
                }
                if (!usageEntities.containsKey(event.getUuid())) {
                    usageEntities.put(event.getUuid(), new InstanceUsageArtEntity());
                }
                InstanceUsageArtEntity usageEntity = (InstanceUsageArtEntity)usageEntities.get(event.getUuid());
                ReportingInstanceCreateEvent createEvent = (ReportingInstanceCreateEvent)createEvents.get(event.getUuid());
                if (createEvent == null) {
                    log.error((Object)("Usage event without create event:" + event.getUuid()));
                    return true;
                }
                if (!(eventMs < report.getBeginMs() && eventMs > report.getEndMs() || InstanceArtGenerator.this.addParentNodes(report, createEvent, usageEntity))) {
                    return true;
                }
                if (!prevDataMap.containsKey(key)) {
                    usageEntity.setDurationMs(Math.max(usageEntity.getDurationMs(), InstanceArtGenerator.overlap(report.getBeginMs(), report.getEndMs(), createEvent.getTimestampMs(), eventMs)));
                    Double fractionalVal = InstanceArtGenerator.fractionalUsage(report.getBeginMs(), report.getEndMs(), createEvent.getTimestampMs(), eventMs, event.getValue());
                    InstanceArtGenerator.addMetricValueToUsageEntity(usageEntity, event.getMetric(), event.getDimension(), fractionalVal);
                    log.debug((Object)String.format("new metric time:%d-%d report:%d-%d uuid:%s metric:%s dim:%s val:%f fraction:%f", createEvent.getTimestampMs(), eventMs, report.getBeginMs(), report.getEndMs(), event.getUuid(), event.getMetric(), event.getDimension(), event.getValue(), fractionalVal));
                    prevDataMap.put(key, new MetricPrevData(eventMs, eventMs, event.getValue(), event.getSequenceNum()));
                } else {
                    MetricPrevData prevData = (MetricPrevData)prevDataMap.get(key);
                    usageEntity.setDurationMs(Math.max(usageEntity.getDurationMs(), InstanceArtGenerator.overlap(report.getBeginMs(), report.getEndMs(), prevData.firstMs, eventMs)));
                    if (event.getSequenceNum() < prevData.lastSeq || event.getSequenceNum() == 0L) {
                        Double fractionalVal = InstanceArtGenerator.fractionalUsage(report.getBeginMs(), report.getEndMs(), prevData.lastMs, eventMs, event.getValue());
                        InstanceArtGenerator.addMetricValueToUsageEntity(usageEntity, event.getMetric(), event.getDimension(), fractionalVal);
                        log.debug((Object)String.format("reset time:%d-%d report:%d-%d uuid:%s metric:%s dim:%s val:%f fraction:%f", prevData.lastMs, eventMs, report.getBeginMs(), report.getEndMs(), event.getUuid(), event.getMetric(), event.getDimension(), event.getValue(), fractionalVal));
                    } else {
                        Double fractionalVal = InstanceArtGenerator.fractionalUsage(report.getBeginMs(), report.getEndMs(), prevData.lastMs, eventMs, event.getValue() - prevData.lastVal);
                        InstanceArtGenerator.addMetricValueToUsageEntity(usageEntity, event.getMetric(), event.getDimension(), fractionalVal);
                        log.debug((Object)String.format("event time:%d-%d report:%d-%d uuid:%s metric:%s dim:%s val:%f lastVal:%f fraction:%f", prevData.lastMs, eventMs, report.getBeginMs(), report.getEndMs(), event.getUuid(), event.getMetric(), event.getDimension(), event.getValue(), prevData.lastVal, fractionalVal));
                    }
                    prevDataMap.put(key, new MetricPrevData(prevData.firstMs, eventMs, event.getValue(), event.getSequenceNum()));
                }
                return true;
            }
        });
        for (AvailabilityZoneArtEntity zone : report.getZones().values()) {
            UsageTotalsArtEntity zoneUsage = zone.getUsageTotals();
            for (AccountArtEntity account : zone.getAccounts().values()) {
                UsageTotalsArtEntity accountUsage = account.getUsageTotals();
                for (UserArtEntity user : account.getUsers().values()) {
                    UsageTotalsArtEntity userUsage = user.getUsageTotals();
                    for (InstanceArtEntity instance : user.getInstances().values()) {
                        InstanceArtGenerator.updateUsageTotals(userUsage, instance);
                        InstanceArtGenerator.updateUsageTotals(accountUsage, instance);
                        InstanceArtGenerator.updateUsageTotals(zoneUsage, instance);
                    }
                }
            }
        }
        return report;
    }

    private boolean addParentNodes(ReportArtEntity report, ReportingInstanceCreateEvent createEvent, InstanceUsageArtEntity usageEntity) {
        UserArtEntity user;
        AccountArtEntity account;
        AvailabilityZoneArtEntity zone;
        HashMap users = Maps.newHashMap();
        HashMap accounts = Maps.newHashMap();
        ReportingUser reportingUser = this.getUserById(users, createEvent.getUserId());
        if (reportingUser == null) {
            log.error((Object)("No user corresponding to event:" + createEvent.getUserId()));
            return false;
        }
        String accountName = this.getAccountNameById(accounts, reportingUser.getAccountId());
        if (accountName == null) {
            log.error((Object)("No account corresponding to user:" + reportingUser.getAccountId()));
            return false;
        }
        if (!report.getZones().containsKey(createEvent.getAvailabilityZone())) {
            report.getZones().put(createEvent.getAvailabilityZone(), new AvailabilityZoneArtEntity());
        }
        if (!(zone = report.getZones().get(createEvent.getAvailabilityZone())).getAccounts().containsKey(accountName)) {
            zone.getAccounts().put(accountName, new AccountArtEntity());
        }
        if (!(account = zone.getAccounts().get(accountName)).getUsers().containsKey(reportingUser.getName())) {
            account.getUsers().put(reportingUser.getName(), new UserArtEntity());
        }
        if (!(user = account.getUsers().get(reportingUser.getName())).getInstances().containsKey(createEvent.getUuid())) {
            InstanceArtEntity instance = new InstanceArtEntity(createEvent.getInstanceType(), createEvent.getInstanceId(), usageEntity);
            user.getInstances().put(createEvent.getUuid(), instance);
            instance.getUsage().addInstanceCnt(1);
        }
        return true;
    }

    private static void updateUsageTotals(UsageTotalsArtEntity totals, InstanceArtEntity instance) {
        InstanceUsageArtEntity totalEntity = totals.getInstanceTotals();
        InstanceUsageArtEntity usage = instance.getUsage();
        totalEntity.addUsage(usage);
        Map<String, InstanceUsageArtEntity> typeTotals = totals.getTypeTotals();
        if (!typeTotals.containsKey(instance.getInstanceType().toLowerCase())) {
            typeTotals.put(instance.getInstanceType().toLowerCase(), new InstanceUsageArtEntity());
        }
        InstanceUsageArtEntity typeTotal = typeTotals.get(instance.getInstanceType().toLowerCase());
        typeTotal.addUsage(usage);
    }

    private static void addMetricValueToUsageEntity(InstanceUsageArtEntity usage, String metric, String dim, double val) {
        long value = new Double(val).longValue();
        if (metric.equals(METRIC_NET_IN_BYTES) && dim.equals(DIM_TOTAL)) {
            usage.addNetTotalInBytes(value);
        } else if (metric.equals(METRIC_NET_OUT_BYTES) && dim.equals(DIM_TOTAL)) {
            usage.addNetTotalOutBytes(value);
        } else if (metric.equals(METRIC_NET_EXT_IN_BYTES) && dim.equals(DIM_DEFAULT)) {
            usage.addNetExternalInBytes(value);
        } else if (metric.equals(METRIC_NET_EXT_OUT_BYTES) && dim.equals(DIM_DEFAULT)) {
            usage.addNetExternalOutBytes(value);
        } else if (metric.equals(METRIC_DISK_IN_BYTES)) {
            usage.addDiskReadBytes(value);
        } else if (metric.equals(METRIC_DISK_OUT_BYTES)) {
            usage.addDiskWriteBytes(value);
        } else if (metric.equals(METRIC_DISK_READ_OPS)) {
            usage.addDiskReadOps(value);
        } else if (metric.equals(METRIC_DISK_WRITE_OPS)) {
            usage.addDiskWriteOps(value);
        } else if (metric.equals(METRIC_VOLUME_READ)) {
            usage.addDiskReadTime(value);
        } else if (metric.equals(METRIC_VOLUME_WRITE)) {
            usage.addDiskWriteTime(value);
        } else if (metric.equals(METRIC_CPU_USAGE_MS) && dim.equals(DIM_DEFAULT)) {
            usage.addCpuUtilizationMs(value);
        } else {
            log.debug((Object)("Unrecognized metric for report:" + metric + "/" + dim));
        }
    }

    private static long overlap(long repBegin, long repEnd, long perBegin, long perEnd) {
        if (perEnd <= repBegin || perBegin >= repEnd) {
            return 0L;
        }
        return Math.min(repEnd, perEnd) - Math.max(repBegin, perBegin);
    }

    private static Double fractionalUsage(long repBegin, long repEnd, long perBegin, long perEnd, Double usage) {
        if (usage == null) {
            return null;
        }
        double duration = perEnd - perBegin;
        double overlapping = InstanceArtGenerator.overlap(repBegin, repEnd, perBegin, perEnd);
        return usage * (overlapping / duration);
    }

    protected void foreachInstanceUsageEvent(long startInclusive, long endExclusive, Predicate<? super ReportingInstanceUsageEvent> callback) {
        this.foreach(ReportingInstanceUsageEvent.class, this.between(startInclusive, endExclusive), true, callback);
    }

    protected void foreachInstanceCreateEvent(long endExclusive, Predicate<? super ReportingInstanceCreateEvent> callback) {
        this.foreach(ReportingInstanceCreateEvent.class, this.before(endExclusive), true, callback);
    }

    private static class MetricPrevData {
        private final long firstMs;
        private final double lastVal;
        private final long lastMs;
        private final long lastSeq;

        private MetricPrevData(long firstMs, long lastMs, double lastVal, long lastSeq) {
            this.firstMs = firstMs;
            this.lastMs = lastMs;
            this.lastVal = lastVal;
            this.lastSeq = lastSeq;
        }
    }

    private static class InstanceMetricDimensionKey {
        private final String instanceUuid;
        private final String metric;
        private final String dimension;

        public InstanceMetricDimensionKey(String instanceUuid, String metric, String dimension) {
            this.instanceUuid = instanceUuid;
            this.metric = metric;
            this.dimension = dimension;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dimension == null ? 0 : this.dimension.hashCode());
            result = 31 * result + (this.instanceUuid == null ? 0 : this.instanceUuid.hashCode());
            result = 31 * result + (this.metric == null ? 0 : this.metric.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InstanceMetricDimensionKey other = (InstanceMetricDimensionKey)obj;
            if (this.dimension == null ? other.dimension != null : !this.dimension.equals(other.dimension)) {
                return false;
            }
            if (this.instanceUuid == null ? other.instanceUuid != null : !this.instanceUuid.equals(other.instanceUuid)) {
                return false;
            }
            return !(this.metric == null ? other.metric != null : !this.metric.equals(other.metric));
        }
    }
}

