/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.ElasticIpArtEntity;
import com.eucalyptus.reporting.art.entity.ElasticIpUsageArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.entity.UserArtEntity;
import com.eucalyptus.reporting.art.generator.AbstractArtGenerator;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.event_store.ReportingElasticIpAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingInstanceCreateEvent;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class ElasticIpArtGenerator
extends AbstractArtGenerator {
    private static Logger log = Logger.getLogger(ElasticIpArtGenerator.class);

    @Override
    public ReportArtEntity generateReportArt(final ReportArtEntity report) {
        log.debug((Object)"Generating report ART");
        final HashMap ipToDeleteTimesMap = Maps.newHashMap();
        this.foreachElasticIpDeleteEvent(this.buildTimestampMap(report, ipToDeleteTimesMap, this.ipUuid()));
        final HashMap reportingUsersById = Maps.newHashMap();
        final HashMap accountNamesById = Maps.newHashMap();
        final HashMap ipToAllocationListMap = Maps.newHashMap();
        this.foreachElasticIpCreateEvent((Predicate<? super ReportingElasticIpCreateEvent>)new Predicate<ReportingElasticIpCreateEvent>(){

            public boolean apply(ReportingElasticIpCreateEvent createEvent) {
                ElasticIpArtEntity elasticIp;
                UserArtEntity user;
                AccountArtEntity account;
                Long deleteTime = ElasticIpArtGenerator.this.findTimeAfter(ipToDeleteTimesMap, createEvent.getIp(), createEvent.getTimestampMs());
                if (deleteTime < report.getBeginMs()) {
                    return true;
                }
                if (createEvent.getTimestampMs() > report.getEndMs()) {
                    return false;
                }
                ReportingUser reportingUser = ElasticIpArtGenerator.this.getUserById(reportingUsersById, createEvent.getUserId());
                if (reportingUser == null) {
                    log.error((Object)("No user corresponding to event:" + createEvent.getUserId() + " " + createEvent.getIp()));
                    return true;
                }
                String accountName = ElasticIpArtGenerator.this.getAccountNameById(accountNamesById, reportingUser.getAccountId());
                if (accountName == null) {
                    log.error((Object)("No account corresponding to user:" + reportingUser.getAccountId() + " " + createEvent.getIp()));
                    return true;
                }
                List allocations = (List)ipToAllocationListMap.get(createEvent.getIp());
                if (allocations == null) {
                    allocations = Lists.newArrayList();
                    ipToAllocationListMap.put(createEvent.getIp(), allocations);
                }
                allocations.add(new ElasticIpAllocation(accountName, reportingUser.getName(), createEvent.getIp(), createEvent.getTimestampMs(), deleteTime));
                if (!report.getAccounts().containsKey(accountName)) {
                    account = new AccountArtEntity();
                    report.getAccounts().put(accountName, account);
                } else {
                    account = report.getAccounts().get(accountName);
                }
                if (!account.getUsers().containsKey(reportingUser.getName())) {
                    user = new UserArtEntity();
                    account.getUsers().put(reportingUser.getName(), user);
                } else {
                    user = account.getUsers().get(reportingUser.getName());
                }
                if (!user.getElasticIps().containsKey(createEvent.getIp())) {
                    elasticIp = new ElasticIpArtEntity();
                    elasticIp.getUsage().setIpNum(1L);
                    user.getElasticIps().put(createEvent.getIp(), elasticIp);
                } else {
                    elasticIp = user.getElasticIps().get(createEvent.getIp());
                }
                elasticIp.getUsage().setDurationMs(elasticIp.getUsage().getDurationMs() + ElasticIpArtGenerator.this.calculateDuration(report, createEvent.getTimestampMs(), deleteTime));
                return true;
            }
        });
        final HashMap instanceEntities = Maps.newHashMap();
        this.foreachInstanceCreateEvent((Predicate<? super ReportingInstanceCreateEvent>)new Predicate<ReportingInstanceCreateEvent>(){

            public boolean apply(ReportingInstanceCreateEvent createEvent) {
                if (createEvent.getTimestampMs() > report.getEndMs()) {
                    return false;
                }
                InstanceArtEntity instance = new InstanceArtEntity(createEvent.getInstanceType(), createEvent.getInstanceId());
                instanceEntities.put(createEvent.getUuid(), instance);
                return true;
            }
        });
        final HashMap ipToDetachTimesMap = Maps.newHashMap();
        this.foreachElasticIpDetachEvent(this.buildTimestampMap(report, ipToDetachTimesMap, this.ipUuid()));
        this.foreachElasticIpAttachEvent((Predicate<? super ReportingElasticIpAttachEvent>)new Predicate<ReportingElasticIpAttachEvent>(){

            public boolean apply(ReportingElasticIpAttachEvent attachEvent) {
                Long deleteTime = ElasticIpArtGenerator.this.findTimeAfter(ipToDeleteTimesMap, attachEvent.getIp(), attachEvent.getTimestampMs());
                Long detachTime = Math.min(deleteTime, ElasticIpArtGenerator.this.findTimeAfter(ipToDetachTimesMap, attachEvent.getIp(), attachEvent.getTimestampMs()));
                if (detachTime < report.getBeginMs()) {
                    return true;
                }
                if (attachEvent.getTimestampMs() > report.getEndMs()) {
                    return false;
                }
                Long attachmentDuration = ElasticIpArtGenerator.this.calculateDuration(report, attachEvent.getTimestampMs(), detachTime);
                ElasticIpArtEntity entity = ElasticIpArtGenerator.this.findEntityForTimestamp(report, ipToAllocationListMap, attachEvent.getIp(), attachEvent.getTimestampMs());
                if (entity == null) {
                    log.error((Object)("Unable to find elastic ip owner for attachment, instance uuid: " + attachEvent.getInstanceUuid()));
                    return true;
                }
                InstanceArtEntity instance = (InstanceArtEntity)instanceEntities.get(attachEvent.getInstanceUuid());
                if (instance == null) {
                    log.error((Object)("Unable to find instance for attachment, instance uuid: " + attachEvent.getInstanceUuid()));
                    return true;
                }
                ElasticIpUsageArtEntity usage = entity.getInstanceAttachments().get(instance.getInstanceId());
                if (usage == null) {
                    usage = new ElasticIpUsageArtEntity();
                    usage.setIpNum(1L);
                    entity.getInstanceAttachments().put(instance.getInstanceId(), usage);
                }
                usage.setDurationMs(usage.getDurationMs() + attachmentDuration);
                return true;
            }
        });
        for (AccountArtEntity account : report.getAccounts().values()) {
            for (UserArtEntity user : account.getUsers().values()) {
                for (ElasticIpArtEntity ip : user.getElasticIps().values()) {
                    ElasticIpArtGenerator.updateUsageTotals(user.getUsageTotals().getElasticIpTotals(), ip.getUsage());
                    ElasticIpArtGenerator.updateUsageTotals(account.getUsageTotals().getElasticIpTotals(), ip.getUsage());
                    ElasticIpArtGenerator.updateUsageTotals(report.getUsageTotals().getElasticIpTotals(), ip.getUsage());
                }
            }
        }
        return report;
    }

    private ElasticIpArtEntity findEntityForTimestamp(ReportArtEntity report, Map<String, List<ElasticIpAllocation>> ipUuidToAllocationListMap, String uuid, Long timestampMs) {
        ElasticIpArtEntity entity = null;
        List<ElasticIpAllocation> allocations = ipUuidToAllocationListMap.get(uuid);
        if (allocations != null) {
            for (ElasticIpAllocation allocation : allocations) {
                UserArtEntity userArtEntity;
                if (allocation.startTime >= timestampMs || allocation.endTime < timestampMs) continue;
                AccountArtEntity accountArtEntity = report.getAccounts().get(allocation.accountName);
                if (accountArtEntity == null || (userArtEntity = accountArtEntity.getUsers().get(allocation.userName)) == null) break;
                entity = userArtEntity.getElasticIps().get(allocation.ip);
                break;
            }
        }
        return entity;
    }

    private Long calculateDuration(ReportArtEntity report, Long start, Long end) {
        return Math.min(report.getEndMs(), end) - Math.max(report.getBeginMs(), start);
    }

    private Function<ReportingEventSupport, String> ipUuid() {
        return new Function<ReportingEventSupport, String>(){

            public String apply(ReportingEventSupport reportingEventSupport) {
                return ElasticIpArtGenerator.this.getIpUuid(reportingEventSupport);
            }
        };
    }

    private String getIpUuid(ReportingEventSupport event) {
        if (event instanceof ReportingElasticIpDeleteEvent) {
            return ((ReportingElasticIpDeleteEvent)event).getIp();
        }
        if (event instanceof ReportingElasticIpDetachEvent) {
            return ((ReportingElasticIpDetachEvent)event).getIp();
        }
        throw new IllegalStateException("Unsupported event type: " + event.getClass());
    }

    protected void foreachElasticIpCreateEvent(Predicate<? super ReportingElasticIpCreateEvent> callback) {
        this.foreach(ReportingElasticIpCreateEvent.class, (Criterion)Restrictions.conjunction(), true, callback);
    }

    protected void foreachElasticIpDeleteEvent(Predicate<? super ReportingElasticIpDeleteEvent> callback) {
        this.foreach(ReportingElasticIpDeleteEvent.class, (Criterion)Restrictions.conjunction(), true, callback);
    }

    protected void foreachElasticIpAttachEvent(Predicate<? super ReportingElasticIpAttachEvent> callback) {
        this.foreach(ReportingElasticIpAttachEvent.class, (Criterion)Restrictions.conjunction(), true, callback);
    }

    protected void foreachElasticIpDetachEvent(Predicate<? super ReportingElasticIpDetachEvent> callback) {
        this.foreach(ReportingElasticIpDetachEvent.class, (Criterion)Restrictions.conjunction(), true, callback);
    }

    protected void foreachInstanceCreateEvent(Predicate<? super ReportingInstanceCreateEvent> callback) {
        this.foreach(ReportingInstanceCreateEvent.class, (Criterion)Restrictions.conjunction(), true, callback);
    }

    private static void updateUsageTotals(ElasticIpUsageArtEntity totalEntity, ElasticIpUsageArtEntity newEntity) {
        totalEntity.setIpNum(totalEntity.getIpNum() + newEntity.getIpNum());
        totalEntity.setDurationMs(totalEntity.getDurationMs() + newEntity.getDurationMs());
    }

    private static class ElasticIpAllocation {
        private final String accountName;
        private final String userName;
        private final String ip;
        private final Long startTime;
        private final Long endTime;

        private ElasticIpAllocation(String accountName, String userName, String ip, Long startTime, Long endTime) {
            this.accountName = accountName;
            this.userName = userName;
            this.ip = ip;
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }
}

