/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.ComputeCapacityArtEntity;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.generator.ArtGenerator;
import com.eucalyptus.reporting.domain.ReportingComputeDomainModel;
import com.google.common.base.Objects;

public class ComputeCapacityArtGenerator
implements ArtGenerator {
    @Override
    public ReportArtEntity generateReportArt(ReportArtEntity report) {
        ReportingComputeDomainModel model = ReportingComputeDomainModel.getGlobalComputeDomainModel();
        ComputeCapacityArtEntity globalCapacity = report.getUsageTotals().getComputeCapacityArtEntity();
        globalCapacity.setSizeS3ObjectAvailableGB(this.nullSafe(model.getSizeS3ObjectAvailableGB()));
        globalCapacity.setSizeS3ObjectTotalGB(this.nullSafe(model.getSizeS3ObjectTotalGB()));
        globalCapacity.setNumPublicIpsAvailable(this.nullSafe(model.getNumPublicIpsAvailable()));
        globalCapacity.setNumPublicIpsTotal(this.nullSafe(model.getNumPublicIpsTotal()));
        globalCapacity.setEc2ComputeUnitsAvailable(0);
        globalCapacity.setEc2ComputeUnitsTotal(0);
        globalCapacity.setEc2DiskUnitsAvailable(0);
        globalCapacity.setEc2DiskUnitsTotal(0);
        globalCapacity.setEc2MemoryUnitsAvailable(0);
        globalCapacity.setEc2MemoryUnitsTotal(0);
        globalCapacity.setSizeEbsAvailableGB(0L);
        globalCapacity.setSizeEbsTotalGB(0L);
        for (String zone : ReportingComputeDomainModel.getZones()) {
            AvailabilityZoneArtEntity zoneEntity = report.getZones().get(zone);
            if (zoneEntity == null) {
                zoneEntity = new AvailabilityZoneArtEntity();
                report.getZones().put(zone, zoneEntity);
            }
            ComputeCapacityArtEntity zoneCapacity = zoneEntity.getUsageTotals().getComputeCapacityArtEntity();
            ReportingComputeDomainModel.ReportingComputeZoneDomainModel zoneModel = ReportingComputeDomainModel.getZoneComputeDomainModel(zone);
            zoneCapacity.setEc2ComputeUnitsAvailable(this.nullSafe(zoneModel.getEc2ComputeUnitsAvailable()));
            zoneCapacity.setEc2ComputeUnitsTotal(this.nullSafe(zoneModel.getEc2ComputeUnitsTotal()));
            zoneCapacity.setEc2DiskUnitsAvailable(this.nullSafe(zoneModel.getEc2DiskUnitsAvailable()));
            zoneCapacity.setEc2DiskUnitsTotal(this.nullSafe(zoneModel.getEc2DiskUnitsTotal()));
            zoneCapacity.setEc2MemoryUnitsAvailable(this.nullSafe(zoneModel.getEc2MemoryUnitsAvailable()));
            zoneCapacity.setEc2MemoryUnitsTotal(this.nullSafe(zoneModel.getEc2MemoryUnitsTotal()));
            zoneCapacity.setSizeEbsAvailableGB(this.nullSafe(zoneModel.getSizeEbsAvailableGB()));
            zoneCapacity.setSizeEbsTotalGB(this.nullSafe(zoneModel.getSizeEbsTotalGB()));
            for (String vmType : zoneModel.getVmTypes()) {
                zoneCapacity.setInstancesAvailableForType(vmType, this.nullSafe(zoneModel.getInstancesAvailableForType(vmType)));
                zoneCapacity.setInstancesTotalForType(vmType, this.nullSafe(zoneModel.getInstancesTotalForType(vmType)));
            }
            globalCapacity.setEc2ComputeUnitsAvailable(globalCapacity.getEc2ComputeUnitsAvailable() + zoneCapacity.getEc2ComputeUnitsAvailable());
            globalCapacity.setEc2ComputeUnitsTotal(globalCapacity.getEc2ComputeUnitsTotal() + zoneCapacity.getEc2ComputeUnitsTotal());
            globalCapacity.setEc2DiskUnitsAvailable(globalCapacity.getEc2DiskUnitsAvailable() + zoneCapacity.getEc2DiskUnitsAvailable());
            globalCapacity.setEc2DiskUnitsTotal(globalCapacity.getEc2DiskUnitsTotal() + zoneCapacity.getEc2DiskUnitsTotal());
            globalCapacity.setEc2MemoryUnitsAvailable(globalCapacity.getEc2MemoryUnitsAvailable() + zoneCapacity.getEc2MemoryUnitsAvailable());
            globalCapacity.setEc2MemoryUnitsTotal(globalCapacity.getEc2MemoryUnitsTotal() + zoneCapacity.getEc2MemoryUnitsTotal());
            globalCapacity.setSizeEbsAvailableGB(globalCapacity.getSizeEbsAvailableGB() + zoneCapacity.getSizeEbsAvailableGB());
            globalCapacity.setSizeEbsTotalGB(globalCapacity.getSizeEbsTotalGB() + zoneCapacity.getSizeEbsTotalGB());
            for (String vmType : zoneModel.getVmTypes()) {
                globalCapacity.setInstancesAvailableForType(vmType, this.nullSafe(globalCapacity.getInstancesAvailableForType(vmType)) + zoneCapacity.getInstancesAvailableForType(vmType));
                globalCapacity.setInstancesTotalForType(vmType, this.nullSafe(globalCapacity.getInstancesTotalForType(vmType)) + zoneCapacity.getInstancesTotalForType(vmType));
            }
        }
        return report;
    }

    private Integer nullSafe(Integer value) {
        return (Integer)Objects.firstNonNull((Object)value, (Object)0);
    }

    private Long nullSafe(Long value) {
        return (Long)Objects.firstNonNull((Object)value, (Object)0L);
    }
}

