/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.generator;

import com.eucalyptus.entities.Entities;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.generator.ArtGenerator;
import com.eucalyptus.reporting.domain.ReportingAccount;
import com.eucalyptus.reporting.domain.ReportingAccountDao;
import com.eucalyptus.reporting.domain.ReportingUser;
import com.eucalyptus.reporting.domain.ReportingUserDao;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityTransaction;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public abstract class AbstractArtGenerator
implements ArtGenerator {
    protected static final String TIMESTAMP_MS = "timestampMs";

    protected ReportingUser getUserById(String userId) {
        return ReportingUserDao.getInstance().getReportingUser(userId);
    }

    protected ReportingAccount getAccountById(String accountId) {
        return ReportingAccountDao.getInstance().getReportingAccount(accountId);
    }

    protected ReportingUser getUserById(Map<String, ReportingUser> reportingUsersById, String userId) {
        ReportingUser reportingUser;
        if (reportingUsersById.containsKey(userId)) {
            reportingUser = reportingUsersById.get(userId);
        } else {
            reportingUser = this.getUserById(userId);
            reportingUsersById.put(userId, reportingUser);
        }
        return reportingUser;
    }

    protected String getAccountNameById(Map<String, String> accountNamesById, String accountId) {
        String accountName;
        if (accountNamesById.containsKey(accountId)) {
            accountName = accountNamesById.get(accountId);
        } else {
            ReportingAccount account = this.getAccountById(accountId);
            accountName = account == null ? null : account.getName();
            accountNamesById.put(accountId, accountName);
        }
        return accountName;
    }

    protected Criterion between(Long beginInclusive, Long endExclusive) {
        return Restrictions.conjunction().add((Criterion)Restrictions.ge((String)TIMESTAMP_MS, (Object)beginInclusive)).add(this.before(endExclusive));
    }

    protected Criterion before(Long endExclusive) {
        return Restrictions.lt((String)TIMESTAMP_MS, (Object)endExclusive);
    }

    protected <KT, ET extends ReportingEventSupport> Predicate<ET> buildTimestampMap(final ReportArtEntity report, final Map<KT, List<Long>> keyToTimesMap, final Function<ET, KT> keyBuilder) {
        return new Predicate<ET>(){

            public boolean apply(ET event) {
                List endTimes;
                if (((ReportingEventSupport)event).getTimestampMs() <= report.getEndMs()) {
                    Object key = keyBuilder.apply(event);
                    endTimes = (List)keyToTimesMap.get(key);
                    if (endTimes == null) {
                        endTimes = Lists.newArrayList((Object[])new Long[]{((ReportingEventSupport)event).getTimestampMs()});
                        keyToTimesMap.put(key, endTimes);
                    } else {
                        endTimes.add(((ReportingEventSupport)event).getTimestampMs());
                    }
                } else {
                    return false;
                }
                Collections.sort(endTimes);
                return true;
            }
        };
    }

    protected <KT> Long findTimeAfter(Map<KT, List<Long>> keyToEndTimesMap, KT key, Long startTime) {
        Long timeAfter = Long.MAX_VALUE;
        List<Long> endTimesForKey = keyToEndTimesMap.get(key);
        if (endTimesForKey != null) {
            for (Long endTime : endTimesForKey) {
                if (endTime <= startTime) continue;
                timeAfter = endTime;
                break;
            }
        }
        return timeAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ET> void foreach(Class<ET> eventClass, Criterion criterion, boolean ascending, Predicate<? super ET> callback) {
        EntityTransaction transaction = Entities.get(eventClass);
        ScrollableResults results = null;
        try {
            results = Entities.createCriteria(eventClass).setReadOnly(true).setCacheable(false).setCacheMode(CacheMode.IGNORE).setFetchSize(100).add(criterion).addOrder(ascending ? Order.asc((String)TIMESTAMP_MS) : Order.desc((String)TIMESTAMP_MS)).scroll(ScrollMode.FORWARD_ONLY);
            while (results.next()) {
                Object event = results.get(0);
                if (!callback.apply(event)) {
                    break;
                }
                Entities.evict((Object)event);
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            transaction.rollback();
        }
    }
}

