/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.entity;

import com.eucalyptus.reporting.art.ArtObject;
import com.eucalyptus.reporting.art.entity.BucketUsageArtEntity;
import com.eucalyptus.reporting.art.entity.ElasticIpArtEntity;
import com.eucalyptus.reporting.art.entity.InstanceArtEntity;
import com.eucalyptus.reporting.art.entity.UsageTotalsArtEntity;
import com.eucalyptus.reporting.art.entity.VolumeArtEntity;
import com.eucalyptus.reporting.art.util.IndentingStringBuffer;
import java.util.HashMap;
import java.util.Map;

public class UserArtEntity
implements ArtObject {
    private final Map<String, InstanceArtEntity> instances = new HashMap<String, InstanceArtEntity>();
    private final Map<String, VolumeArtEntity> volumes = new HashMap<String, VolumeArtEntity>();
    private final Map<String, BucketUsageArtEntity> bucketsUsage = new HashMap<String, BucketUsageArtEntity>();
    private final Map<String, ElasticIpArtEntity> elasticIps = new HashMap<String, ElasticIpArtEntity>();
    private final UsageTotalsArtEntity totals = new UsageTotalsArtEntity();

    public Map<String, InstanceArtEntity> getInstances() {
        return this.instances;
    }

    public Map<String, VolumeArtEntity> getVolumes() {
        return this.volumes;
    }

    public Map<String, BucketUsageArtEntity> getBucketUsage() {
        return this.bucketsUsage;
    }

    public Map<String, ElasticIpArtEntity> getElasticIps() {
        return this.elasticIps;
    }

    public UsageTotalsArtEntity getUsageTotals() {
        return this.totals;
    }

    public String prettyPrint(int numIndents) {
        IndentingStringBuffer sb = new IndentingStringBuffer();
        sb.appendIndentLine(numIndents, String.format("(totals:%s", this.totals));
        if (this.instances.keySet().size() > 0) {
            sb.append(" instances:{");
            for (String uuid : this.instances.keySet()) {
                sb.appendIndentLine(numIndents + 1, this.instances.get(uuid).toString());
            }
            sb.appendIndentLine(numIndents, "})");
        } else if (this.volumes.keySet().size() > 0) {
            sb.append(" volumes:{");
            for (String uuid : this.volumes.keySet()) {
                sb.appendIndentLine(numIndents + 1, this.volumes.get(uuid).toString());
            }
            sb.appendIndentLine(numIndents, "})");
        }
        return sb.toString();
    }
}

