/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting.art.entity;

import com.eucalyptus.reporting.art.ArtObject;
import com.eucalyptus.reporting.art.entity.AccountArtEntity;
import com.eucalyptus.reporting.art.entity.AvailabilityZoneArtEntity;
import com.eucalyptus.reporting.art.entity.UsageTotalsArtEntity;
import com.eucalyptus.reporting.art.util.IndentingStringBuffer;
import java.util.HashMap;
import java.util.Map;

public class ReportArtEntity
implements ArtObject {
    private long beginMs;
    private long endMs;
    private Map<String, AvailabilityZoneArtEntity> zones;
    private Map<String, AccountArtEntity> accounts;
    private UsageTotalsArtEntity usageTotals;

    public ReportArtEntity(long beginMs, long endMs) {
        this.beginMs = beginMs;
        this.endMs = endMs;
        this.zones = new HashMap<String, AvailabilityZoneArtEntity>();
        this.accounts = new HashMap<String, AccountArtEntity>();
        this.usageTotals = new UsageTotalsArtEntity();
    }

    public long getBeginMs() {
        return this.beginMs;
    }

    public long getEndMs() {
        return this.endMs;
    }

    public Map<String, AvailabilityZoneArtEntity> getZones() {
        return this.zones;
    }

    public Map<String, AccountArtEntity> getAccounts() {
        return this.accounts;
    }

    public UsageTotalsArtEntity getUsageTotals() {
        return this.usageTotals;
    }

    public String prettyPrint(int numIndents) {
        IndentingStringBuffer sb = new IndentingStringBuffer();
        sb.appendIndentLine(numIndents, String.format("(period:%d-%d totals:%s zones:{", this.beginMs, this.endMs, this.usageTotals));
        for (String zonename : this.zones.keySet()) {
            sb.appendIndentLine(numIndents + 1, this.zones.get(zonename).prettyPrint(numIndents + 1));
        }
        sb.appendIndentLine(numIndents, "})");
        return sb.toString();
    }
}

