/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.DatabaseAuthProvider;
import com.eucalyptus.auth.api.AccountProvider;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.blockstorage.State;
import com.eucalyptus.blockstorage.Volume;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.objectstorage.entities.Bucket;
import com.eucalyptus.objectstorage.entities.ObjectEntity;
import com.eucalyptus.reporting.domain.ReportingAccountCrud;
import com.eucalyptus.reporting.domain.ReportingUserCrud;
import com.eucalyptus.reporting.event_store.EventStoreSupport;
import com.eucalyptus.reporting.event_store.ReportingElasticIpAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingElasticIpEventStore;
import com.eucalyptus.reporting.event_store.ReportingEventSupport;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingS3ObjectEventStore;
import com.eucalyptus.reporting.event_store.ReportingVolumeAttachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeDetachEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeEventStore;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotCreateEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotDeleteEvent;
import com.eucalyptus.reporting.event_store.ReportingVolumeSnapshotEventStore;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.HasNaturalId;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;

public final class ReportingDataVerifier {
    private static Supplier<AccountProvider> accountProviderSupplier = Suppliers.memoize((Supplier)new Supplier<AccountProvider>(){

        public AccountProvider get() {
            return Accounts.getAccountProvider() != null ? Accounts.getAccountProvider() : new DatabaseAuthProvider();
        }
    });

    public static String addMissingReportingEvents() {
        View liveView = ReportingDataVerifier.getLiveView();
        View reportingView = ReportingDataVerifier.getReportingView();
        EventDescriptionBag eventDescriptions = ReportingDataVerifier.getEventDifferences(liveView, reportingView);
        ReportingDataVerifier.addReportingEvents(eventDescriptions);
        return "Live:\n" + liveView + "\nReporting:\n" + reportingView + "\nGap:\n" + eventDescriptions;
    }

    public static View getLiveView() {
        return new LiveViewBuilder().buildView();
    }

    public static View getReportingView() {
        return new ReportingViewBuilder().buildView();
    }

    public static EventDescriptionBag getEventDifferences(View target, View current) {
        EventDescriptionBag description = new EventDescriptionBag();
        HashSet types = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)target.typedResourceHolders, (Iterable)current.typedResourceHolders), ReportingDataVerifier.type()));
        for (Class type : types) {
            TypedResourceHolder targetHolder = target.getHolderOrNull(type);
            TypedResourceHolder currentHolder = current.getHolderOrNull(type);
            if (targetHolder == null) {
                description.delete.add(currentHolder);
                continue;
            }
            if (currentHolder == null) {
                description.create.add(targetHolder);
                continue;
            }
            TypedResourceHolder add = new TypedResourceHolder(type);
            TypedResourceHolder del = new TypedResourceHolder(type);
            TypedResourceHolder att = new TypedResourceHolder(type);
            TypedResourceHolder det = new TypedResourceHolder(type);
            ArrayList targetCopy = Lists.newArrayList((Iterable)targetHolder.resources);
            ArrayList currentCopy = Lists.newArrayList((Iterable)currentHolder.resources);
            targetCopy.removeAll(currentHolder.resources);
            currentCopy.removeAll(targetHolder.resources);
            HashSet keys = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)targetCopy, (Iterable)currentCopy), ReportingDataVerifier.key()));
            for (ResourceKey key : keys) {
                TypedResourceHolder addTo;
                ArrayList findIn;
                if (!Iterables.contains((Iterable)Iterables.transform((Iterable)targetCopy, ReportingDataVerifier.key()), (Object)key)) {
                    findIn = currentCopy;
                    addTo = del;
                } else if (!Iterables.contains((Iterable)Iterables.transform((Iterable)currentCopy, ReportingDataVerifier.key()), (Object)key)) {
                    findIn = targetCopy;
                    addTo = add;
                } else if (((ResourceWithRelation)Iterables.find((Iterable)targetCopy, ReportingDataVerifier.withKeyMatching(key))).relationId == null) {
                    findIn = currentCopy;
                    addTo = det;
                } else {
                    findIn = targetCopy;
                    addTo = att;
                }
                addTo.resources.add(Iterables.find((Iterable)findIn, ReportingDataVerifier.withKeyMatching(key)));
            }
            if (!add.resources.isEmpty()) {
                description.create.add(add);
            }
            if (!del.resources.isEmpty()) {
                description.delete.add(del);
            }
            if (!att.resources.isEmpty()) {
                description.attach.add(att);
            }
            if (det.resources.isEmpty()) continue;
            description.detach.add(det);
        }
        return description;
    }

    public static void addReportingEvents(EventDescriptionBag eventDescriptions) {
        long timestamp = System.currentTimeMillis();
        HashSet verifiedUserIds = Sets.newHashSet();
        ReportingDataVerifier.addCreateEvents(verifiedUserIds, eventDescriptions.create);
        ReportingDataVerifier.addDeleteEvents(timestamp, eventDescriptions.delete);
        ReportingDataVerifier.addAttachmentStateEvents(timestamp, verifiedUserIds, eventDescriptions.attach, true);
        ReportingDataVerifier.addAttachmentStateEvents(timestamp, verifiedUserIds, eventDescriptions.detach, false);
    }

    private static Predicate<ResourceWithRelation<?>> withKeyMatching(ResourceKey key) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)key), ReportingDataVerifier.key());
    }

    private static void addCreateEvents(Set<String> verifiedUserIds, List<TypedResourceHolder> holders) {
        HashMap accountNumberToAccountAdminMap = Maps.newHashMap();
        for (TypedResourceHolder holder : holders) {
            for (ResourceWithRelation resource : holder.resources) {
                EventStoreSupport store;
                if (Address.class.equals((Object)holder.type)) {
                    store = ReportingElasticIpEventStore.getInstance();
                    Address address = ReportingDataVerifier.findAddress(resource.resourceKey.toString());
                    if (address == null || !ReportingDataVerifier.ensureUserAndAccount(verifiedUserIds, address.getUserId())) continue;
                    ((ReportingElasticIpEventStore)store).insertCreateEvent(address.getCreationTimestamp().getTime(), address.getUserId(), address.getDisplayName());
                    continue;
                }
                if (ObjectEntity.class.equals((Object)holder.type)) {
                    User user;
                    store = ReportingS3ObjectEventStore.getInstance();
                    S3ObjectKey key = (S3ObjectKey)resource.resourceKey;
                    ObjectEntity objectInfo = ReportingDataVerifier.findObjectInfo(key);
                    String accountId = null;
                    try {
                        accountId = Accounts.lookupAccountById((String)objectInfo.getOwnerCanonicalId()).getAccountNumber();
                    }
                    catch (Exception e) {
                        accountId = null;
                    }
                    User user2 = user = objectInfo == null ? null : ReportingDataVerifier.getAccountAdmin(accountNumberToAccountAdminMap, accountId);
                    if (objectInfo == null || user == null || !ReportingDataVerifier.ensureUserAndAccount(verifiedUserIds, user.getUserId())) continue;
                    ((ReportingS3ObjectEventStore)store).insertS3ObjectCreateEvent(objectInfo.getBucket().getBucketName(), objectInfo.getObjectKey(), objectInfo.getVersionId(), objectInfo.getSize(), objectInfo.getCreationTimestamp().getTime(), user.getUserId());
                    continue;
                }
                if (Snapshot.class.equals((Object)holder.type)) {
                    Volume volume;
                    store = ReportingVolumeSnapshotEventStore.getInstance();
                    Snapshot snapshot = ReportingDataVerifier.findSnapshot(resource.resourceKey.toString());
                    Volume volume2 = volume = snapshot == null ? null : ReportingDataVerifier.findVolumeById(snapshot.getParentVolume());
                    if (snapshot == null || volume == null || !ReportingDataVerifier.ensureUserAndAccount(verifiedUserIds, snapshot.getOwnerUserId())) continue;
                    ((ReportingVolumeSnapshotEventStore)store).insertCreateEvent(snapshot.getNaturalId(), volume.getNaturalId(), snapshot.getDisplayName(), snapshot.getCreationTimestamp().getTime(), snapshot.getOwnerUserId(), snapshot.getVolumeSize().intValue());
                    continue;
                }
                if (!Volume.class.equals((Object)holder.type)) continue;
                store = ReportingVolumeEventStore.getInstance();
                Volume volume = ReportingDataVerifier.findVolume(resource.resourceKey.toString());
                if (volume == null || !ReportingDataVerifier.ensureUserAndAccount(verifiedUserIds, volume.getOwnerUserId())) continue;
                ((ReportingVolumeEventStore)store).insertCreateEvent(volume.getNaturalId(), volume.getDisplayName(), volume.getCreationTimestamp().getTime(), volume.getOwnerUserId(), volume.getPartition(), volume.getSize().intValue());
            }
        }
    }

    private static void addDeleteEvents(long timestamp, List<TypedResourceHolder> holders) {
        for (TypedResourceHolder holder : holders) {
            for (ResourceWithRelation resource : holder.resources) {
                EventStoreSupport store;
                if (Address.class.equals((Object)holder.type)) {
                    store = ReportingElasticIpEventStore.getInstance();
                    ((ReportingElasticIpEventStore)store).insertDeleteEvent(resource.resourceKey.toString(), timestamp);
                    continue;
                }
                if (ObjectEntity.class.equals((Object)holder.type)) {
                    store = ReportingS3ObjectEventStore.getInstance();
                    S3ObjectKey key = (S3ObjectKey)resource.resourceKey;
                    ((ReportingS3ObjectEventStore)store).insertS3ObjectDeleteEvent(key.bucketName, key.objectKey, key.objectVersion, timestamp);
                    continue;
                }
                if (Snapshot.class.equals((Object)holder.type)) {
                    store = ReportingVolumeSnapshotEventStore.getInstance();
                    ((ReportingVolumeSnapshotEventStore)store).insertDeleteEvent(resource.resourceKey.toString(), timestamp);
                    continue;
                }
                if (!Volume.class.equals((Object)holder.type)) continue;
                store = ReportingVolumeEventStore.getInstance();
                ((ReportingVolumeEventStore)store).insertDeleteEvent(resource.resourceKey.toString(), timestamp);
            }
        }
    }

    private static void addAttachmentStateEvents(long timestamp, Set<String> verifiedUserIds, List<TypedResourceHolder> holders, boolean attach) {
        for (TypedResourceHolder holder : holders) {
            for (ResourceWithRelation resource : holder.resources) {
                Volume volume;
                if (Address.class.equals((Object)holder.type)) {
                    ReportingElasticIpEventStore store = ReportingElasticIpEventStore.getInstance();
                    if (attach) {
                        store.insertAttachEvent(resource.resourceKey.toString(), resource.relationId, timestamp);
                        continue;
                    }
                    store.insertDetachEvent(resource.resourceKey.toString(), resource.relationId, timestamp);
                    continue;
                }
                if (!Volume.class.equals((Object)holder.type) || (volume = ReportingDataVerifier.findVolume(resource.resourceKey.toString())) == null || !ReportingDataVerifier.ensureUserAndAccount(verifiedUserIds, volume.getOwnerUserId())) continue;
                ReportingVolumeEventStore store = ReportingVolumeEventStore.getInstance();
                if (attach) {
                    store.insertAttachEvent(volume.getNaturalId(), resource.relationId, volume.getSize().intValue(), timestamp);
                    continue;
                }
                store.insertDetachEvent(volume.getNaturalId(), resource.relationId, timestamp);
            }
        }
    }

    private static ResourceWithRelation<SimpleResourceKey> resource(String resourceId, String relationId) {
        return new ResourceWithRelation<SimpleResourceKey>(new SimpleResourceKey(resourceId), relationId, null);
    }

    private static ResourceWithRelation<S3ObjectKey> s3ObjectResource(String bucketName, String objectKey, String objectVersion) {
        return ReportingDataVerifier.s3ObjectResource(new S3ObjectKey(bucketName, objectKey, objectVersion));
    }

    private static ResourceWithRelation<S3ObjectKey> s3ObjectResource(S3ObjectKey key) {
        return new ResourceWithRelation<S3ObjectKey>(key, null, null);
    }

    private static void append(StringBuilder builder, List<TypedResourceHolder> typedResourceHolders) {
        for (TypedResourceHolder typedResourceHolder : typedResourceHolders) {
            builder.append("Type: ").append(typedResourceHolder.type.getSimpleName()).append("\n");
            for (ResourceWithRelation resource : typedResourceHolder.resources) {
                builder.append(resource).append("\n");
            }
        }
    }

    private static boolean ensureUserAndAccount(Set<String> userIds, String userId) {
        boolean verified;
        if (userIds.contains(userId)) {
            verified = true;
        } else {
            try {
                User user = ReportingDataVerifier.getAccountProvider().lookupUserById(userId);
                Account account = user.getAccount();
                ReportingAccountCrud.getInstance().createOrUpdateAccount(account.getAccountNumber(), account.getName());
                ReportingUserCrud.getInstance().createOrUpdateUser(user.getUserId(), account.getAccountNumber(), user.getName());
                verified = true;
            }
            catch (AuthException e) {
                verified = false;
            }
        }
        return verified;
    }

    private static User getAccountAdmin(Map<String, User> accountNumberToAccountAdminMap, String accountNumber) {
        User user = accountNumberToAccountAdminMap.get(accountNumber);
        if (user == null && !accountNumberToAccountAdminMap.containsKey(accountNumber)) {
            try {
                user = ReportingDataVerifier.getAccountProvider().lookupAccountById(accountNumber).lookupAdmin();
                accountNumberToAccountAdminMap.put(accountNumber, user);
            }
            catch (AuthException e) {
                accountNumberToAccountAdminMap.put(accountNumber, null);
            }
        }
        return user;
    }

    private static AccountProvider getAccountProvider() {
        return (AccountProvider)accountProviderSupplier.get();
    }

    private static Address findAddress(String uuid) {
        return (Address)Iterables.getFirst((Iterable)Iterables.filter((Iterable)Iterables.concat((Iterable)Addresses.getInstance().listValues(), (Iterable)Addresses.getInstance().listDisabledValues()), (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)uuid), ReportingDataVerifier.naturalId())), null);
    }

    private static ObjectEntity findObjectInfo(S3ObjectKey key) {
        try {
            ObjectEntity objectInfo = new ObjectEntity();
            objectInfo.setBucket(new Bucket(key.bucketName));
            objectInfo.setObjectKey(key.objectKey);
            objectInfo.setVersionId(key.objectVersion == null ? "null" : key.objectVersion);
            List infos = Transactions.findAll((Object)objectInfo);
            if (infos.isEmpty()) {
                return null;
            }
            ObjectEntity result = (ObjectEntity)infos.get(0);
            for (ObjectEntity current : infos) {
                if (!current.getCreationTimestamp().after(result.getCreationTimestamp())) continue;
                result = current;
            }
            return result;
        }
        catch (TransactionException e) {
            return null;
        }
    }

    private static Snapshot findSnapshot(String uuid) {
        return ReportingDataVerifier.findOrNull(Snapshot.naturalId((String)uuid));
    }

    private static Volume findVolume(String uuid) {
        return ReportingDataVerifier.findOrNull(Volume.naturalId((String)uuid));
    }

    private static Volume findVolumeById(String id) {
        return ReportingDataVerifier.findOrNull(Volume.named(null, (String)id));
    }

    private static <T> T findOrNull(T example) {
        try {
            return (T)Transactions.find(example);
        }
        catch (TransactionException e) {
            return null;
        }
    }

    private static Function<HasNaturalId, String> naturalId() {
        return new Function<HasNaturalId, String>(){

            public String apply(HasNaturalId hasNaturalId) {
                return hasNaturalId.getNaturalId();
            }
        };
    }

    private static Function<TypedResourceHolder, Class<?>> type() {
        return new Function<TypedResourceHolder, Class<?>>(){

            public Class<?> apply(TypedResourceHolder typedResourceHolder) {
                return typedResourceHolder.type;
            }
        };
    }

    private static Function<ResourceWithRelation<?>, ResourceKey> key() {
        return new Function<ResourceWithRelation<?>, ResourceKey>(){

            public ResourceKey apply(ResourceWithRelation<?> resource) {
                return ((ResourceWithRelation)resource).resourceKey;
            }
        };
    }

    private static class ResourceWithRelation<KT extends ResourceKey> {
        @Nonnull
        private final KT resourceKey;
        @Nullable
        private final String relationId;

        private ResourceWithRelation(@Nonnull KT resourceKey, @Nullable String relationId) {
            this.resourceKey = resourceKey;
            this.relationId = relationId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("key:").append(this.resourceKey);
            if (this.relationId != null) {
                builder.append("; relation:").append(this.relationId);
            }
            return builder.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceWithRelation that = (ResourceWithRelation)o;
            if (this.relationId != null ? !this.relationId.equals(that.relationId) : that.relationId != null) {
                return false;
            }
            return this.resourceKey.equals(that.resourceKey);
        }

        public int hashCode() {
            int result = this.resourceKey.hashCode();
            result = 31 * result + (this.relationId != null ? this.relationId.hashCode() : 0);
            return result;
        }

        /* synthetic */ ResourceWithRelation(ResourceKey x0, String x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static final class S3ObjectKey
    extends ResourceKey {
        @Nonnull
        private final String bucketName;
        @Nonnull
        private final String objectKey;
        @Nullable
        private final String objectVersion;

        private S3ObjectKey(@Nonnull String bucketName, @Nonnull String objectKey, @Nullable String objectVersion) {
            this.bucketName = bucketName;
            this.objectKey = objectKey;
            this.objectVersion = objectVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            S3ObjectKey that = (S3ObjectKey)o;
            if (!this.bucketName.equals(that.bucketName)) {
                return false;
            }
            if (!this.objectKey.equals(that.objectKey)) {
                return false;
            }
            return !(this.objectVersion != null ? !this.objectVersion.equals(that.objectVersion) : that.objectVersion != null);
        }

        public int hashCode() {
            int result = this.bucketName.hashCode();
            result = 31 * result + this.objectKey.hashCode();
            result = 31 * result + (this.objectVersion != null ? this.objectVersion.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ObjectKey[bucket:" + this.bucketName + "; object:" + this.objectKey + "; version:" + this.objectVersion + ']';
        }
    }

    private static final class SimpleResourceKey
    extends ResourceKey {
        private final String key;

        private SimpleResourceKey(String key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleResourceKey that = (SimpleResourceKey)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key;
        }
    }

    private static abstract class ResourceKey {
        private ResourceKey() {
        }
    }

    private static final class TypedResourceHolder {
        private final Class<?> type;
        private final List<ResourceWithRelation<?>> resources;

        private TypedResourceHolder(Class<?> type) {
            this.type = type;
            this.resources = Lists.newArrayList();
        }
    }

    private static final class ReportingViewBuilder
    extends ViewBuilder {
        private ReportingViewBuilder() {
        }

        @Override
        View buildView() {
            final HashMap addressRelationMap = Maps.newHashMap();
            this.foreach(ReportingElasticIpCreateEvent.class, new Callback<ReportingElasticIpCreateEvent>(){

                public void fire(ReportingElasticIpCreateEvent input) {
                    RelationTimestamp rt = (RelationTimestamp)addressRelationMap.get(input.getIp());
                    if (rt == null || rt.timestamp < input.getTimestampMs()) {
                        addressRelationMap.put(input.getIp(), new RelationTimestamp(null, input.getTimestampMs()));
                    }
                }
            });
            this.foreach(ReportingElasticIpDeleteEvent.class, new Callback<ReportingElasticIpDeleteEvent>(){

                public void fire(ReportingElasticIpDeleteEvent input) {
                    RelationTimestamp rt = (RelationTimestamp)addressRelationMap.get(input.getIp());
                    if (rt == null || rt.timestamp < input.getTimestampMs()) {
                        addressRelationMap.remove(input.getIp());
                    }
                }
            });
            this.foreach(ReportingElasticIpAttachEvent.class, new Callback<ReportingElasticIpAttachEvent>(){

                public void fire(ReportingElasticIpAttachEvent input) {
                    RelationTimestamp rt;
                    if (addressRelationMap.containsKey(input.getIp()) && ((rt = (RelationTimestamp)addressRelationMap.get(input.getIp())) == null || rt.relationId == null || rt.timestamp < input.getTimestampMs())) {
                        addressRelationMap.put(input.getIp(), new RelationTimestamp(input.getInstanceUuid(), input.getTimestampMs()));
                    }
                }
            });
            this.foreach(ReportingElasticIpDetachEvent.class, new Callback<ReportingElasticIpDetachEvent>(){

                public void fire(ReportingElasticIpDetachEvent input) {
                    RelationTimestamp rt;
                    if (addressRelationMap.containsKey(input.getIp()) && (rt = (RelationTimestamp)addressRelationMap.get(input.getIp())) != null && rt.relationId != null && rt.relationId.equals(input.getInstanceUuid()) && rt.timestamp < input.getTimestampMs()) {
                        addressRelationMap.put(input.getIp(), null);
                    }
                }
            });
            final LinkedList s3ObjectList = Lists.newLinkedList();
            this.foreach(ReportingS3ObjectCreateEvent.class, new Callback<ReportingS3ObjectCreateEvent>(){

                public void fire(ReportingS3ObjectCreateEvent input) {
                    s3ObjectList.add(new S3ObjectKey(input.getS3BucketName(), input.getS3ObjectKey(), input.getObjectVersion()));
                }
            });
            this.foreach(ReportingS3ObjectDeleteEvent.class, new Callback<ReportingS3ObjectDeleteEvent>(){

                public void fire(ReportingS3ObjectDeleteEvent input) {
                    s3ObjectList.remove(new S3ObjectKey(input.getS3BucketName(), input.getS3ObjectKey(), input.getObjectVersion()));
                }
            });
            final HashMap volumeRelationMap = Maps.newHashMap();
            this.foreach(ReportingVolumeCreateEvent.class, new Callback<ReportingVolumeCreateEvent>(){

                public void fire(ReportingVolumeCreateEvent input) {
                    volumeRelationMap.put(input.getUuid(), null);
                }
            });
            this.foreach(ReportingVolumeDeleteEvent.class, new Callback<ReportingVolumeDeleteEvent>(){

                public void fire(ReportingVolumeDeleteEvent input) {
                    volumeRelationMap.remove(input.getUuid());
                }
            });
            this.foreach(ReportingVolumeAttachEvent.class, new Callback<ReportingVolumeAttachEvent>(){

                public void fire(ReportingVolumeAttachEvent input) {
                    RelationTimestamp rt;
                    if (volumeRelationMap.containsKey(input.getVolumeUuid()) && ((rt = (RelationTimestamp)volumeRelationMap.get(input.getVolumeUuid())) == null || rt.timestamp < input.getTimestampMs())) {
                        volumeRelationMap.put(input.getVolumeUuid(), new RelationTimestamp(input.getInstanceUuid(), input.getTimestampMs()));
                    }
                }
            });
            this.foreach(ReportingVolumeDetachEvent.class, new Callback<ReportingVolumeDetachEvent>(){

                public void fire(ReportingVolumeDetachEvent input) {
                    RelationTimestamp rt;
                    if (volumeRelationMap.containsKey(input.getVolumeUuid()) && (rt = (RelationTimestamp)volumeRelationMap.get(input.getVolumeUuid())) != null && rt.relationId.equals(input.getInstanceUuid()) && rt.timestamp < input.getTimestampMs()) {
                        volumeRelationMap.put(input.getVolumeUuid(), null);
                    }
                }
            });
            final LinkedList snapshotList = Lists.newLinkedList();
            this.foreach(ReportingVolumeSnapshotCreateEvent.class, new Callback<ReportingVolumeSnapshotCreateEvent>(){

                public void fire(ReportingVolumeSnapshotCreateEvent input) {
                    snapshotList.add(input.getUuid());
                }
            });
            this.foreach(ReportingVolumeSnapshotDeleteEvent.class, new Callback<ReportingVolumeSnapshotDeleteEvent>(){

                public void fire(ReportingVolumeSnapshotDeleteEvent input) {
                    snapshotList.remove(input.getUuid());
                }
            });
            View view = new View();
            for (Map.Entry addressEntry : addressRelationMap.entrySet()) {
                view.add(Address.class, (String)addressEntry.getKey(), addressEntry.getValue() == null ? null : ((RelationTimestamp)addressEntry.getValue()).relationId);
            }
            for (S3ObjectKey s3ObjectKey : s3ObjectList) {
                view.add(ObjectEntity.class, ReportingDataVerifier.s3ObjectResource(s3ObjectKey));
            }
            for (Map.Entry volumeEntry : volumeRelationMap.entrySet()) {
                view.add(Volume.class, (String)volumeEntry.getKey(), volumeEntry.getValue() == null ? null : ((RelationTimestamp)volumeEntry.getValue()).relationId);
            }
            for (String snapshotUuid : snapshotList) {
                view.add(Snapshot.class, snapshotUuid, null);
            }
            return view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <RET extends ReportingEventSupport> void foreach(Class<RET> type, Callback<RET> callback) {
            EntityTransaction transaction = Entities.get(type);
            ScrollableResults results = null;
            try {
                results = Entities.createCriteria(type).setCacheable(false).setReadOnly(true).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).scroll(ScrollMode.FORWARD_ONLY);
                while (results.next()) {
                    Object result = results.get(0);
                    if (!type.isInstance(result)) continue;
                    callback.fire(type.cast(result));
                }
            }
            finally {
                if (results != null) {
                    try {
                        results.close();
                    }
                    finally {
                        transaction.rollback();
                    }
                } else {
                    transaction.rollback();
                }
            }
        }

        private static final class RelationTimestamp {
            private final String relationId;
            private final long timestamp;

            private RelationTimestamp(String relationId, long timestamp) {
                this.relationId = relationId;
                this.timestamp = timestamp;
            }
        }
    }

    private static final class LiveViewBuilder
    extends ViewBuilder {
        private LiveViewBuilder() {
        }

        @Override
        View buildView() {
            try {
                String relatedId;
                String id;
                View view = new View();
                for (Address address : Iterables.concat((Iterable)Addresses.getInstance().listValues(), (Iterable)Addresses.getInstance().listDisabledValues())) {
                    if (!address.isAllocated() || address.isSystemOwned()) continue;
                    id = address.getNaturalId();
                    relatedId = null;
                    if (address.isAssigned()) {
                        relatedId = address.getInstanceUuid();
                    }
                    view.add(Address.class, id, relatedId);
                }
                for (ObjectEntity objectInfo : Transactions.findAll((Object)new ObjectEntity())) {
                    if (!Boolean.FALSE.equals(objectInfo.getIsDeleteMarker())) continue;
                    view.add(ObjectEntity.class, ReportingDataVerifier.s3ObjectResource(objectInfo.getBucket().getBucketName(), objectInfo.getObjectKey(), objectInfo.getVersionId()));
                }
                for (Volume volume : Transactions.findAll((Object)Volume.named(null, null))) {
                    if (!volume.isReady()) continue;
                    id = volume.getNaturalId();
                    relatedId = null;
                    try {
                        relatedId = VmInstances.lookupVolumeAttachment((String)volume.getDisplayName()).getVmInstance().getInstanceId();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                    view.add(Volume.class, id, relatedId);
                }
                for (Snapshot snapshot : Transactions.findAll((Object)Snapshot.named(null, null))) {
                    if (!EnumSet.of(State.EXTANT, State.BUSY).contains(snapshot.getState())) continue;
                    view.add(Snapshot.class, snapshot.getNaturalId(), null);
                }
                return view;
            }
            catch (TransactionException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private static abstract class ViewBuilder {
        private ViewBuilder() {
        }

        abstract View buildView();
    }

    public static class View {
        private final List<TypedResourceHolder> typedResourceHolders = Lists.newArrayList();

        private <CM> void add(@Nonnull Class<CM> type, @Nonnull String resourceId, @Nullable String relationId) {
            this.add(type, ReportingDataVerifier.resource(resourceId, relationId));
        }

        private <CM> void add(@Nonnull Class<CM> type, @Nonnull ResourceWithRelation<?> resource) {
            TypedResourceHolder holder = this.getHolder(type);
            holder.resources.add(resource);
        }

        @Nonnull
        private <CM> TypedResourceHolder getHolder(@Nonnull Class<CM> type) {
            TypedResourceHolder holder = this.getHolderOrNull(type);
            if (holder == null) {
                holder = new TypedResourceHolder(type);
                this.typedResourceHolders.add(holder);
            }
            return holder;
        }

        private <CM> TypedResourceHolder getHolderOrNull(final Class<CM> type) {
            return (TypedResourceHolder)Iterables.get((Iterable)Iterables.filter(this.typedResourceHolders, (Predicate)new Predicate<TypedResourceHolder>(){

                public boolean apply(TypedResourceHolder typedResourceHolder) {
                    return type.equals(typedResourceHolder.type);
                }
            }), (int)0, null);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            ReportingDataVerifier.append(builder, this.typedResourceHolders);
            return builder.toString();
        }
    }

    public static class EventDescriptionBag {
        private final List<TypedResourceHolder> create = Lists.newArrayList();
        private final List<TypedResourceHolder> delete = Lists.newArrayList();
        private final List<TypedResourceHolder> attach = Lists.newArrayList();
        private final List<TypedResourceHolder> detach = Lists.newArrayList();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Creation required:\n");
            ReportingDataVerifier.append(builder, this.create);
            builder.append("Deletion required:\n");
            ReportingDataVerifier.append(builder, this.delete);
            builder.append("Attach required:\n");
            ReportingDataVerifier.append(builder, this.attach);
            builder.append("Detach required:\n");
            ReportingDataVerifier.append(builder, this.detach);
            return builder.toString();
        }
    }
}

