/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting;

import com.eucalyptus.reporting.Period;
import com.eucalyptus.reporting.ReportFormat;
import com.eucalyptus.reporting.ReportType;
import com.eucalyptus.reporting.art.entity.ReportArtEntity;
import com.eucalyptus.reporting.art.renderer.RendererFactory;
import com.eucalyptus.reporting.units.Units;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class ReportGenerator {
    private static final Logger log = Logger.getLogger(ReportGenerator.class);
    private static final ReportGenerator instance = new ReportGenerator();

    private ReportGenerator() {
    }

    public static ReportGenerator getInstance() {
        return instance;
    }

    public void generateReport(Period period, ReportFormat format, ReportType type, Units displayUnits, OutputStream out) throws IOException {
        if (period == null) {
            throw new IllegalArgumentException("Period can't be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can't be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out can't be null");
        }
        if (format == null) {
            format = ReportFormat.HTML;
        }
        ReportArtEntity report = new ReportArtEntity(period.getBeginningMs(), period.getEndingMs());
        if (displayUnits == null) {
            displayUnits = Units.getDefaultDisplayUnits();
        }
        type.getGenerator().generateReportArt(report);
        RendererFactory.getRenderer(type, format).render(report, out, displayUnits);
    }
}

