/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting;

import com.eucalyptus.reporting.Period;
import com.eucalyptus.reporting.ReportFormat;
import com.eucalyptus.reporting.ReportGenerator;
import com.eucalyptus.reporting.ReportType;
import com.eucalyptus.reporting.units.Units;
import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ReportGenerationFacade {
    public static String generateReport(@Nonnull String type, @Nonnull String format, long start, long end) throws ReportGenerationException {
        return ReportGenerationFacade.generateReport(type, format, null, start, end);
    }

    public static String generateReport(@Nonnull String type, @Nonnull String format, @Nullable Units units, long start, long end) throws ReportGenerationException {
        long adjustedEndTime;
        long maxEndTime = System.currentTimeMillis();
        long l = adjustedEndTime = end > maxEndTime ? maxEndTime : end;
        if (start >= adjustedEndTime) {
            throw new ReportGenerationArgumentException("Invalid report period");
        }
        ReportGenerator generator = ReportGenerator.getInstance();
        ByteArrayOutputStream reportOutput = new ByteArrayOutputStream(10240);
        try {
            generator.generateReport(new Period(start, adjustedEndTime), ReportFormat.valueOf(format.toUpperCase()), ReportType.valueOf(type.toUpperCase().replace('-', '_')), units, reportOutput);
        }
        catch (Exception e) {
            throw new ReportGenerationException("Error generating report", e);
        }
        return new String(reportOutput.toByteArray(), Charsets.UTF_8);
    }

    public static final class ReportGenerationArgumentException
    extends ReportGenerationException {
        private static final long serialVersionUID = 1L;

        public ReportGenerationArgumentException(String message) {
            super(message);
        }
    }

    public static class ReportGenerationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ReportGenerationException(String message) {
            super(message);
        }

        public ReportGenerationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

