/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.reporting;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public final class Period {
    private final Long beginningMs;
    private final Long endingMs;

    public Period(long beginningMs, long endingMs) {
        if (endingMs < beginningMs) {
            throw new IllegalArgumentException("endingMs < beginningMs");
        }
        this.beginningMs = new Long(beginningMs);
        this.endingMs = new Long(endingMs);
    }

    public long getBeginningMs() {
        return this.beginningMs;
    }

    public long getEndingMs() {
        return this.endingMs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.beginningMs == null ? 0 : this.beginningMs.hashCode());
        result = 31 * result + (this.endingMs == null ? 0 : this.endingMs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Period other = (Period)obj;
        if (this.beginningMs == null ? other.beginningMs != null : !this.beginningMs.equals(other.beginningMs)) {
            return false;
        }
        return !(this.endingMs == null ? other.endingMs != null : !this.endingMs.equals(other.endingMs));
    }

    public String toString() {
        return String.format("[%d-%d]", this.beginningMs, this.endingMs);
    }

    public static Period defaultPeriod() {
        long yesterday = Period.yesterday();
        return new Period(yesterday, yesterday + TimeUnit.DAYS.toMillis(1L));
    }

    private static long yesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }
}

