/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.troubleshooting.checker;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.records.Logs;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class PermGenMemoryCheck {
    private static final Logger LOG = Logger.getLogger(PermGenMemoryCheck.class);
    private static final ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor();
    private static final int OUT_OF_PERM_GEN_MEMORY_FAULT_ID = 1005;
    private static final long DEFAULT_POLL_INTERVAL = 60000L;
    private static final Class<? extends ComponentId> DEFAULT_COMPONENT_ID_CLASS = Eucalyptus.class;

    private PermGenMemoryCheck() {
    }

    public static ScheduledFuture<?> start(PermGenMemoryChecker checker) {
        return pool.scheduleWithFixedDelay(checker, 0L, checker.pollInterval, TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        pool.shutdownNow();
    }

    public static class PermGenMemoryChecker
    implements Runnable {
        private double ratio;
        private long pollInterval;
        private Class<? extends ComponentId> componentIdClass;
        private boolean alreadyFaulted = false;

        public PermGenMemoryChecker(double ratio) {
            this.ratio = ratio;
            this.pollInterval = 60000L;
            this.componentIdClass = DEFAULT_COMPONENT_ID_CLASS;
        }

        public PermGenMemoryChecker(double ratio, Class<? extends ComponentId> componentIdClass, long pollInterval) {
            this.ratio = ratio;
            this.pollInterval = pollInterval;
            this.componentIdClass = componentIdClass;
        }

        @Override
        public void run() {
            List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
            boolean noPermGenBeans = true;
            if (null != beans) {
                for (MemoryPoolMXBean bean : beans) {
                    String name = bean.getName();
                    if (!name.contains("Perm Gen") || bean.getType() != MemoryType.NON_HEAP) continue;
                    noPermGenBeans = false;
                    double actualRatio = (double)bean.getUsage().getUsed() / (double)bean.getUsage().getMax();
                    Logs.extreme().debug((Object)("Perm-gen memory usage ratio = " + actualRatio));
                    if (!(actualRatio > this.ratio) || this.alreadyFaulted) continue;
                    Faults.forComponent(Eucalyptus.class).havingId(1005).withVar("component", Eucalyptus.INSTANCE.getFaultLogPrefix()).log();
                    this.alreadyFaulted = true;
                }
            }
            if (noPermGenBeans) {
                LOG.warn((Object)"Unable to find any mxbeans for Perm-Gen usage");
            }
        }
    }
}

