/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.troubleshooting.checker;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.records.Logs;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class DiskResourceCheck {
    private static final Logger LOG = Logger.getLogger(DiskResourceCheck.class);
    private static final ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor();
    private static final int OUT_OF_DISK_SPACE_FAULT_ID = 1003;
    private static final long DEFAULT_POLL_INTERVAL = 5000L;
    private static final Class<? extends ComponentId> DEFAULT_COMPONENT_ID_CLASS = Eucalyptus.class;

    private DiskResourceCheck() {
    }

    public static ScheduledFuture<?> start(Checker checker) {
        return pool.scheduleWithFixedDelay(checker, 0L, checker.pollInterval, TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        pool.shutdownNow();
    }

    public static class Checker
    implements Runnable {
        private Set<LocationInfo> locations = new HashSet<LocationInfo>();
        private long pollInterval;
        private Class<? extends ComponentId> componentIdClass;
        private Set<LocationInfo> alreadyFaulted = new HashSet<LocationInfo>();

        public Checker(LocationInfo locationInfo) {
            this.locations.add(locationInfo);
            this.pollInterval = 5000L;
            this.componentIdClass = DEFAULT_COMPONENT_ID_CLASS;
        }

        public Checker(LocationInfo locationInfo, Class<? extends ComponentId> componentIdClass, long pollTime) {
            this.locations.add(locationInfo);
            this.componentIdClass = componentIdClass;
            this.pollInterval = pollTime;
        }

        public Checker(List<LocationInfo> locations, Class<? extends ComponentId> componentIdClass, long pollTime) {
            this.locations.addAll(locations);
            this.componentIdClass = componentIdClass;
            this.pollInterval = pollTime;
        }

        @Override
        public void run() {
            if (null != this.locations) {
                for (LocationInfo location : this.locations) {
                    Logs.extreme().debug((Object)("Polling disk " + location.getFile() + ", pollInterval=" + this.pollInterval + ", threshold = " + location.getThreshold()));
                    try {
                        long usableSpace = location.getFile().getUsableSpace();
                        if (usableSpace < location.getThreshold()) {
                            if (this.alreadyFaulted.contains(location)) continue;
                            Faults.forComponent(this.componentIdClass).havingId(1003).withVar("component", ComponentIds.lookup(this.componentIdClass).getFaultLogPrefix()).withVar("file", location.getFile().getAbsolutePath()).log();
                            this.alreadyFaulted.add(location);
                            continue;
                        }
                        this.alreadyFaulted.remove(location);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Disk resource check failed for " + location.getFile().getAbsolutePath()), (Throwable)ex);
                    }
                }
            }
        }
    }

    public static class LocationInfo {
        private File file;
        private Long minimumFreeSpace;
        private Double percentFreeSpace;

        public File getFile() {
            return this.file;
        }

        public Long getThreshold() {
            if (null != this.minimumFreeSpace) {
                return this.minimumFreeSpace;
            }
            return (long)((double)this.file.getTotalSpace() * this.percentFreeSpace / 100.0);
        }

        public LocationInfo(File file, Long minimumFreeSpace) {
            this.file = file;
            this.minimumFreeSpace = minimumFreeSpace;
        }

        public LocationInfo(File file, Double percentFreeSpace) {
            this.file = file;
            this.percentFreeSpace = percentFreeSpace;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LocationInfo other = (LocationInfo)obj;
            return !(this.file == null ? other.file != null : !this.file.equals(other.file));
        }
    }
}

