/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.troubleshooting.checker;

import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Faults;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.records.Logs;
import com.eucalyptus.system.SubDirectory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

public class DBResourceCheck
extends Thread {
    private static final Logger LOG = Logger.getLogger(DBResourceCheck.class);
    private static final ScheduledExecutorService pool = Executors.newSingleThreadScheduledExecutor();
    private static final Runnable shutdownHook = new Runnable(){

        @Override
        public void run() {
            if (!pool.isShutdown()) {
                pool.shutdownNow();
            }
        }
    };
    private static final int OUT_OF_DB_CONNECTIONS_FAULT_ID = 1006;
    private static final long DEFAULT_POLL_INTERVAL = 60000L;
    private static final Class<? extends ComponentId> DEFAULT_COMPONENT_ID_CLASS = Eucalyptus.class;

    private DBResourceCheck() {
    }

    public static ScheduledFuture<?> start(DBChecker checker) {
        OrderedShutdown.registerPreShutdownHook((Runnable)shutdownHook);
        return pool.scheduleWithFixedDelay(checker, 0L, checker.pollInterval, TimeUnit.MILLISECONDS);
    }

    public static void shutdown() {
        pool.shutdownNow();
    }

    public static class DBChecker
    implements Runnable {
        private Set<DBPoolInfo> dbPools = new HashSet<DBPoolInfo>();
        private long pollInterval;
        private Class<? extends ComponentId> componentIdClass;
        private Set<DBPoolInfo> alreadyFaulted = new HashSet<DBPoolInfo>();

        public DBChecker(DBPoolInfo dbPool) {
            this.dbPools.add(dbPool);
            this.pollInterval = 60000L;
            this.componentIdClass = DEFAULT_COMPONENT_ID_CLASS;
        }

        public DBChecker(DBPoolInfo dbPool, Class<? extends ComponentId> componentIdClass, long pollTime) {
            this.dbPools.add(dbPool);
            this.componentIdClass = componentIdClass;
            this.pollInterval = pollTime;
        }

        public DBChecker(List<DBPoolInfo> dbPools, Class<? extends ComponentId> componentIdClass, long pollTime) {
            this.dbPools.addAll(dbPools);
            this.componentIdClass = componentIdClass;
            this.pollInterval = pollTime;
        }

        @Override
        public void run() {
            if (null != this.dbPools) {
                for (DBPoolInfo dbPool : this.dbPools) {
                    try {
                        Logs.extreme().debug((Object)("Polling dbpool " + dbPool.getAlias() + ",pollInterval=" + this.pollInterval + ", threshold = " + dbPool.getThreshold()));
                        if (dbPool.getMaximumConnections() - dbPool.getActiveConnections() < dbPool.getThreshold()) {
                            if (this.alreadyFaulted.contains(dbPool)) continue;
                            Faults.forComponent(this.componentIdClass).havingId(1006).withVar("component", ComponentIds.lookup(this.componentIdClass).getFaultLogPrefix()).withVar("alias", dbPool.getAlias()).withVar("maxConnections", "" + dbPool.getMaximumConnections()).withVar("activeConnections", "" + dbPool.getActiveConnections()).withVar("scriptsDir", SubDirectory.SCRIPTS.getFile().getAbsolutePath()).log();
                            this.alreadyFaulted.add(dbPool);
                            continue;
                        }
                        this.alreadyFaulted.remove(dbPool);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("db resource check failed for " + dbPool.getAlias()), (Throwable)ex);
                    }
                }
            }
        }
    }

    public static class DBPoolInfo {
        private String alias;
        private Integer minimumFreeConnections;
        private Double percentFreeConnections;

        public String getAlias() {
            return this.alias;
        }

        public Integer getMaximumConnections() throws ProxoolException {
            return ProxoolFacade.getConnectionPoolDefinition((String)this.alias).getMaximumConnectionCount();
        }

        public Integer getActiveConnections() throws ProxoolException {
            return ProxoolFacade.getSnapshot((String)this.alias, (boolean)true).getActiveConnectionCount();
        }

        public Integer getThreshold() throws ProxoolException {
            if (null != this.minimumFreeConnections) {
                return this.minimumFreeConnections;
            }
            return (int)((double)this.getMaximumConnections().intValue() * this.percentFreeConnections / 100.0);
        }

        public String getURL() throws ProxoolException {
            return ProxoolFacade.getConnectionPoolDefinition((String)this.alias).getCompleteUrl();
        }

        public String getDriver() throws ProxoolException {
            return ProxoolFacade.getConnectionPoolDefinition((String)this.alias).getDriver();
        }

        public DBPoolInfo(String alias, Integer minimumFreeConnections) {
            this.alias = alias;
            this.minimumFreeConnections = minimumFreeConnections;
        }

        public DBPoolInfo(String alias, Double percentFreeConnections) {
            this.alias = alias;
            this.percentFreeConnections = percentFreeConnections;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DBPoolInfo other = (DBPoolInfo)obj;
            return !(this.alias == null ? other.alias != null : !this.alias.equals(other.alias));
        }
    }
}

