/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.troubleshooting.changelisteners;

import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.system.log.LoggingResetter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class LogLevelListener
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(LogLevelListener.class);
    private final String[] logLevels = new String[]{"ALL", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "TRACE", "OFF", "EXTREME"};

    public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
        if (newValue == null) {
            newValue = "";
        }
        String newLogLevel = (String)newValue;
        if (!(newLogLevel = newLogLevel.trim().toUpperCase()).isEmpty() && !Arrays.asList(this.logLevels).contains(newLogLevel)) {
            throw new ConfigurablePropertyException("Invalid log level " + newLogLevel);
        }
        LOG.warn((Object)("Change occurred to property " + t.getQualifiedName() + " with new value " + newValue + "."));
        try {
            t.getField().set(null, t.getTypeParser().apply(newValue));
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
            throw new ConfigurablePropertyException((Throwable)e1);
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
            throw new ConfigurablePropertyException((Throwable)e1);
        }
        if (!newLogLevel.isEmpty()) {
            System.setProperty("euca.log.level", newLogLevel.toUpperCase());
            LoggingResetter.resetLoggingWithXML();
        }
    }

    private static void triggerDBFault() {
        try {
            for (int j = 0; j < 5; ++j) {
                int i;
                Class.forName("org.logicalcobwebs.proxool.ProxoolDriver");
                Connection[] cons = new Connection[505];
                for (i = 0; i < 505; ++i) {
                    cons[i] = DriverManager.getConnection("proxool.eucalyptus_walrus:net.sf.hajdbc.sql.Driver:jdbc:ha-jdbc:eucalyptus_walrus");
                }
                Thread.sleep(30000L);
                for (i = 0; i < 505; ++i) {
                    cons[i].close();
                }
                Thread.sleep(30000L);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex, (Throwable)ex);
        }
    }
}

