/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.troubleshooting;

import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.Faults;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class TestFaultTrigger {
    private static final Logger LOG = Logger.getLogger(TestFaultTrigger.class);

    public static void triggerFault(int id, Properties varProps) {
        for (ComponentId componentId : ComponentIds.list()) {
            try {
                Faults.FaultBuilder faultBuilder = Faults.forComponent(componentId.getClass()).havingId(id);
                LOG.debug((Object)("Triggering fault in component " + componentId.getName() + " with id " + id + " and vars " + varProps));
                if (varProps != null) {
                    Enumeration<?> e = varProps.propertyNames();
                    while (e.hasMoreElements()) {
                        String name = (String)e.nextElement();
                        String value = varProps.getProperty(name);
                        if (value == null) continue;
                        faultBuilder = faultBuilder.withVar(name, value);
                    }
                }
                faultBuilder.log();
            }
            catch (Exception ex) {
                LOG.error((Object)("Error triggering fault: " + ex));
                ex.printStackTrace();
            }
        }
    }
}

