/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.eucalyptus.stats.SensorEntry;
import com.eucalyptus.stats.sensors.BaseStatsSensor;
import com.eucalyptus.stats.sensors.ComponentsSensor;
import com.eucalyptus.stats.sensors.ContextsSensor;
import com.eucalyptus.stats.sensors.DbPoolSensor;
import com.eucalyptus.stats.sensors.JvmMemorySensor;
import com.eucalyptus.stats.sensors.JvmThreadSensor;
import com.eucalyptus.stats.sensors.MuleSensor;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Sensors {
    private static final Logger LOG = Logger.getLogger(Sensors.class);
    private static final String COMPONENT_NAME_PREFIX = "euca.components";
    private static final String CONTEXT_SENSOR_NAME = "euca.components.message_contexts";
    private static final String MULE_APP_TOTAL_SENSOR_NAME = "euca.mule.total";
    private static final String MULE_SERVICES_SENSOR_NAME = "euca.mule.services";
    private static final String DB_POOL_SENSOR_NAME = "euca.db.connection_pools";
    private static final String MEMORY_NAME_PREFIX = "euca.jvm.memory";
    private static final String THREAD_SENSOR_NAME = "euca.jvm.threads.state";
    private static final String MEMORY_GENERAL_SENSOR_NAME = "euca.jvm.memory.general";
    private static final String MEMORY_POOL_SENSOR_NAME = "euca.jvm.memory.pools";
    private static final String MEMORY_GC_SENSOR_NAME = "euca.jvm.memory.gc";
    private static final List<String> DEFAULT_MEM_POOL_TAGS = Lists.newArrayList((Object[])new String[]{"memory", "jvm"});
    private static final List<String> DEFAULT_GC_TAGS = Lists.newArrayList((Object[])new String[]{"memory", "jvm", "gc"});
    private static final List<String> DEFAULT_MEM_HEAP_TAGS = Lists.newArrayList((Object[])new String[]{"memory", "jvm", "heap", "non-heap"});
    private static final List<String> DEFAULT_THREAD_TAGS = Lists.newArrayList((Object[])new String[]{"threads", "jvm"});
    private static final List<String> DEFAULT_DB_TAGS = Lists.newArrayList((Object[])new String[]{"db", "connection_count"});

    public static String pollingIntervalTag(long intervalSec) {
        return "polling_interval: " + String.valueOf(intervalSec) + " sec";
    }

    public static List<SensorEntry> JvmMemorySensors(long pollingInterval, long ttl) {
        ArrayList memorySensors = Lists.newArrayList();
        LOG.info((Object)("Building JVM Memory Pool sensors with ttl " + ttl + "sec and polling interval " + pollingInterval + "sec"));
        ArrayList tags = Lists.newArrayList();
        tags.addAll(DEFAULT_MEM_POOL_TAGS);
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            memorySensors.add(new SensorEntry(BaseStatsSensor.buildSensor(MEMORY_POOL_SENSOR_NAME, "JVM Memory usage for all pools in use", tags, ttl, JvmMemorySensor.POOL), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading memory pool sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        LOG.info((Object)("Building JVM Heap/Non-Heap Memory sensors with ttl " + ttl + "sec and polling interval " + pollingInterval + "sec"));
        tags = Lists.newArrayList();
        tags.addAll(DEFAULT_MEM_HEAP_TAGS);
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            memorySensors.add(new SensorEntry(BaseStatsSensor.buildSensor(MEMORY_GENERAL_SENSOR_NAME, "JVM Memory usage for heap/non-heap in use", tags, ttl, JvmMemorySensor.HEAP), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading memory pool sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        LOG.info((Object)("Building JVM GC sensors with ttl " + ttl + "sec and polling interval " + pollingInterval + "sec"));
        tags = Lists.newArrayList();
        tags.addAll(DEFAULT_GC_TAGS);
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            memorySensors.add(new SensorEntry(BaseStatsSensor.buildSensor(MEMORY_GC_SENSOR_NAME, "JVM GC stats for all GCs in use", tags, ttl, JvmMemorySensor.GC), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading GC sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        return memorySensors;
    }

    public static List<SensorEntry> JvmThreadSensors(long pollingInterval, long ttl) {
        ArrayList threadSensors = Lists.newArrayList();
        LOG.info((Object)("Building JVM Threading sensors with ttl " + ttl + "sec and polling interval " + pollingInterval + "sec"));
        ArrayList tags = Lists.newArrayList();
        tags.addAll(DEFAULT_THREAD_TAGS);
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            threadSensors.add(new SensorEntry(BaseStatsSensor.buildSensor(THREAD_SENSOR_NAME, "JVM Memory usage for all pools in use", tags, ttl, JvmThreadSensor.INSTANCE), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading threading sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        return threadSensors;
    }

    public static List<SensorEntry> DbConnectionPoolSensors(long pollingInterval, long ttl) {
        ArrayList poolSensors = Lists.newArrayList();
        LOG.info((Object)("Building Db conneciton pool sensors with ttl " + ttl + "sec and polling interval " + pollingInterval + "sec"));
        ArrayList tags = Lists.newArrayList();
        tags.addAll(DEFAULT_DB_TAGS);
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            poolSensors.add(new SensorEntry(BaseStatsSensor.buildSensor(DB_POOL_SENSOR_NAME, "Db Connection Pool info for all pools in JVM", tags, ttl, DbPoolSensor.INSTANCE), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading db pool sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        return poolSensors;
    }

    public static List<SensorEntry> ComponentsSensor(int pollingInterval, long ttl) {
        ArrayList sensors = Lists.newArrayList();
        ArrayList tags = Lists.newArrayList();
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            ComponentsSensor sensor = new ComponentsSensor();
            sensor.init(COMPONENT_NAME_PREFIX, "Component state and health status", tags, ttl);
            sensors.add(new SensorEntry(sensor, pollingInterval));
            return sensors;
        }
        catch (Throwable f) {
            LOG.error((Object)"Failed to build service sensors", f);
            throw Exceptions.toUndeclared((Throwable)f);
        }
    }

    public static List<SensorEntry> MuleSensors(int pollingInterval, long ttl) {
        ArrayList sensors = Lists.newArrayList();
        ArrayList tags = Lists.newArrayList();
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            sensors.add(new SensorEntry(BaseStatsSensor.buildSensor(MULE_APP_TOTAL_SENSOR_NAME, "Application total messaging statistics for Mule message bus", tags, ttl, MuleSensor.TOTAL), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading db pool sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        return sensors;
    }

    public static List<SensorEntry> ContextSensor(int pollingInterval, long ttl) {
        ArrayList sensors = Lists.newArrayList();
        ArrayList tags = Lists.newArrayList();
        tags.add(Sensors.pollingIntervalTag(pollingInterval));
        try {
            sensors.add(new SensorEntry(BaseStatsSensor.buildSensor(CONTEXT_SENSOR_NAME, "Count of current message contexts", tags, ttl, ContextsSensor.COUNT), pollingInterval));
        }
        catch (Exception e) {
            LOG.error((Object)"Error loading db pool sensor.");
            throw Exceptions.toUndeclared((Throwable)e);
        }
        return sensors;
    }
}

