/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public enum MuleSensor implements Callable<Map<String, Object>>
{
    TOTAL{
        private String muleDomainString = null;

        @Override
        public Map<String, Object> call() {
            try {
                ObjectName muleApplicationStatsName = ObjectName.getInstance("*:type=Application,name=\"application totals\"");
                MBeanAttributeInfo[] attrs = ManagementFactory.getPlatformMBeanServer().getMBeanInfo(muleApplicationStatsName).getAttributes();
                String[] attrNames = new String[attrs.length];
                TreeMap resultMap = Maps.newTreeMap();
                int i = 0;
                for (MBeanAttributeInfo info : attrs) {
                    attrNames[i++] = info.getName();
                }
                AttributeList resultAttrs = ManagementFactory.getPlatformMBeanServer().getAttributes(muleApplicationStatsName, attrNames);
                for (Object att : resultAttrs) {
                    Attribute tmpAtt = (Attribute)att;
                    resultMap.put(tmpAtt.getName(), tmpAtt.getValue());
                }
                this.resetMuleTotalStats();
                return resultMap;
            }
            catch (Throwable f) {
                LOG.error((Object)"Mule application stats sensor call failed. Cannot gather latest data", f);
                throw Exceptions.toUndeclared((Throwable)f);
            }
        }

        private String getMuleDomain() {
            if (this.muleDomainString == null) {
                for (String domain : ManagementFactory.getPlatformMBeanServer().getDomains()) {
                    if (!domain.startsWith("Mule")) continue;
                    this.muleDomainString = domain;
                    break;
                }
            }
            return this.muleDomainString;
        }

        private void resetMuleTotalStats() {
        }
    }
    ,
    SERVICES{
        private String muleDomainString;

        @Override
        public Map<String, Object> call() {
            try {
                ObjectName muleServiceStatsMatchName = ObjectName.getInstance("*:type=org.mule.statistics,service=*");
                MBeanAttributeInfo[] attrs = ManagementFactory.getPlatformMBeanServer().getMBeanInfo(muleServiceStatsMatchName).getAttributes();
                String[] attrNames = new String[attrs.length];
                TreeMap resultMap = Maps.newTreeMap();
                int i = 0;
                for (MBeanAttributeInfo info : attrs) {
                    attrNames[i++] = info.getName();
                }
                AttributeList resultAttrs = ManagementFactory.getPlatformMBeanServer().getAttributes(muleServiceStatsMatchName, attrNames);
                for (Object att : resultAttrs) {
                    Attribute tmpAtt = (Attribute)att;
                    resultMap.put(tmpAtt.getName(), tmpAtt.getValue());
                }
                return resultMap;
            }
            catch (Throwable f) {
                LOG.error((Object)"Mule service stats sensor call failed. Cannot gather latest data", f);
                throw Exceptions.toUndeclared((Throwable)f);
            }
        }

        private String getMuleDomain() {
            if (this.muleDomainString == null) {
                for (String domain : ManagementFactory.getPlatformMBeanServer().getDomains()) {
                    if (!domain.startsWith("Mule")) continue;
                    this.muleDomainString = domain;
                    break;
                }
            }
            return this.muleDomainString;
        }
    };

    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(MuleSensor.class);
    }
}

