/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.eucalyptus.stats.sensors.BaseStatsSensor;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class MXBeanSensor
extends BaseStatsSensor {
    protected static final Logger LOG = Logger.getLogger(MXBeanSensor.class);
    protected ObjectName wrappedBeanName;
    protected String queryAttribute;
    protected static final long DEFAULT_TTL = 120L;

    public static MXBeanSensor makeSensorFromPlatformMBean(String sensorName, String sensorDescription, MBeanServer server, ObjectName beanName, String attributeNameToQuery) throws Exception {
        MXBeanSensor sensor = new MXBeanSensor();
        sensor.init(sensorName, sensorDescription, null, 120L, MXBeanSensor.queryPlatformMbeanServer(server, beanName, attributeNameToQuery));
        sensor.setWrappedBeanName(beanName);
        sensor.setQueryAttribute(attributeNameToQuery);
        return sensor;
    }

    public static MXBeanSensor makeSensorFromPlatformMBean(String sensorName, String sensorDescription, String beanName, String attributeNameToQuery) throws Exception {
        return MXBeanSensor.makeSensorFromPlatformMBean(sensorName, sensorDescription, ManagementFactory.getPlatformMBeanServer(), new ObjectName(beanName), attributeNameToQuery);
    }

    public static Callable<Map<String, Object>> queryPlatformMbeanServer(final MBeanServer server, final ObjectName beanName, final String attributeName) {
        return new Callable<Map<String, Object>>(){

            @Override
            public Map<String, Object> call() throws Exception {
                HashMap result = Maps.newHashMap();
                if (server == null) {
                    result.put(attributeName, ManagementFactory.getPlatformMBeanServer().getAttribute(beanName, attributeName).toString());
                } else {
                    result.put(attributeName, server.getAttribute(beanName, attributeName).toString());
                }
                return result;
            }
        };
    }

    public ObjectName getWrappedBeanName() {
        return this.wrappedBeanName;
    }

    public void setWrappedBeanName(ObjectName wrappedBeanName) {
        this.wrappedBeanName = wrappedBeanName;
    }

    public String getQueryAttribute() {
        return this.queryAttribute;
    }

    public void setQueryAttribute(String queryAttribute) {
        this.queryAttribute = queryAttribute;
    }
}

