/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public enum JvmThreadSensor implements Callable<Map<String, Object>>
{
    INSTANCE{

        @Override
        public Map<String, Object> call() throws Exception {
            HashMap result = Maps.newHashMap();
            try {
                ThreadMXBean managerBean = ManagementFactory.getThreadMXBean();
                if (managerBean != null) {
                    long[] lockedThreadList = null;
                    long[] monLockedThreadList = null;
                    if (managerBean.isObjectMonitorUsageSupported()) {
                        if (managerBean.isSynchronizerUsageSupported()) {
                            lockedThreadList = managerBean.findDeadlockedThreads();
                        } else {
                            monLockedThreadList = managerBean.findMonitorDeadlockedThreads();
                        }
                    }
                    result.put("DeadlockedThreadCount", lockedThreadList == null ? "" : Integer.valueOf(lockedThreadList.length));
                    result.put("DeadlockedThreads", lockedThreadList == null ? "" : Joiner.on((char)',').join((Iterable)Lists.newArrayList((Object[])new long[][]{lockedThreadList})));
                    result.put("MonitorDeadlockedThreadCount", monLockedThreadList == null ? "" : Integer.valueOf(monLockedThreadList.length));
                    result.put("MonitorDeadlockedThreadCount", monLockedThreadList == null ? "" : Joiner.on((char)',').join((Iterable)Lists.newArrayList((Object[])new long[][]{lockedThreadList})));
                    result.put("ThreadCount", managerBean.getThreadCount());
                    result.put("TotalStartedThreadCount", managerBean.getTotalStartedThreadCount());
                    result.put("PeakThreadCount", managerBean.getPeakThreadCount());
                    result.put("DaemonThreadCount", managerBean.getDaemonThreadCount());
                }
            }
            catch (Throwable f) {
                LOG.warn((Object)"Failed reading heap/non-heap memory usage via mxbean. Continuing.", f);
            }
            return result;
        }
    };

    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(JvmThreadSensor.class);
    }
}

