/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public enum JvmMemorySensor implements Callable<Map<String, Object>>
{
    POOL{

        @Override
        public Map<String, Object> call() throws Exception {
            HashMap result = Maps.newHashMap();
            for (MemoryPoolMXBean managerBean : ManagementFactory.getMemoryPoolMXBeans()) {
                try {
                    String poolName = managerBean.getName();
                    if (Strings.isNullOrEmpty((String)poolName)) {
                        poolName = "unknown";
                    }
                    long used = managerBean.getUsage().getUsed();
                    long max = managerBean.getUsage().getMax();
                    if (managerBean.isUsageThresholdSupported()) {
                        result.put(poolName + ".UsageThresholdBytes", managerBean.getUsageThreshold());
                        result.put(poolName + ".UsageThresholdCount", managerBean.getUsageThresholdCount());
                    }
                    result.put(poolName + ".UsedByes", max);
                    result.put(poolName + ".InitBytes", managerBean.getUsage().getInit());
                    result.put(poolName + ".CommittedBytes", managerBean.getUsage().getCommitted());
                    result.put(poolName + ".MaxBytes", max);
                    result.put(poolName + ".PercentOfMaxUsed", (double)used / (double)max * 100.0);
                    if (managerBean.isCollectionUsageThresholdSupported() && managerBean.getCollectionUsage() != null) {
                        result.put(poolName + ".CollectionUsageUsedBytes", managerBean.getCollectionUsage().getUsed());
                        result.put(poolName + ".CollectionUsageInitBytes", managerBean.getCollectionUsage().getInit());
                        result.put(poolName + ".CollectionUsageCommittedBytes", managerBean.getCollectionUsage().getCommitted());
                        result.put(poolName + ".CollectionUsageMaxBytes", managerBean.getCollectionUsage().getMax());
                        result.put(poolName + ".CollectionUsageThresholdBytes", managerBean.getCollectionUsageThreshold());
                        result.put(poolName + ".CollectionUsageThresholdCount", managerBean.getCollectionUsageThresholdCount());
                    }
                    if (managerBean.getPeakUsage() == null) continue;
                    long peakUsed = managerBean.getPeakUsage().getUsed();
                    result.put(poolName + ".PeakUsedBytes", peakUsed);
                    result.put(poolName + ".PeakCommittedBytes", managerBean.getPeakUsage().getCommitted());
                    result.put(poolName + ".PeakMaxBytes", managerBean.getPeakUsage().getMax());
                    result.put(poolName + ".PercentOfPeakUsed", (double)used / (double)peakUsed * 100.0);
                }
                catch (Throwable f) {
                    LOG.warn((Object)"Failed invoking memory bean sensor. Continuing.", f);
                }
            }
            return result;
        }
    }
    ,
    GC{

        @Override
        public Map<String, Object> call() throws Exception {
            HashMap result = Maps.newHashMap();
            try {
                List<GarbageCollectorMXBean> beans = ManagementFactory.getGarbageCollectorMXBeans();
                if (null != beans) {
                    for (GarbageCollectorMXBean gcBean : beans) {
                        String name = gcBean.getName();
                        result.put(name + ".CollectionCount", gcBean.getCollectionCount());
                        result.put(name + ".CollectionTimeMSec", gcBean.getCollectionTime());
                    }
                }
            }
            catch (Throwable f) {
                LOG.warn((Object)"Error polling GC bean via mxbean. Continuing.", f);
            }
            return result;
        }
    }
    ,
    HEAP{

        @Override
        public Map<String, Object> call() throws Exception {
            HashMap result = Maps.newHashMap();
            try {
                MemoryMXBean managerBean = ManagementFactory.getMemoryMXBean();
                if (managerBean != null) {
                    result.put("HeapUsageBytes", managerBean.getHeapMemoryUsage().getUsed());
                    result.put("NonHeapUsageBytes", managerBean.getNonHeapMemoryUsage().getUsed());
                }
            }
            catch (Throwable f) {
                LOG.warn((Object)"Failed reading heap/non-heap memory usage via mxbean. Continuing.", f);
            }
            return result;
        }
    };

    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(JvmMemorySensor.class);
    }
}

