/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.logicalcobwebs.proxool.ProxoolFacade;

public enum DbPoolSensor implements Callable<Map<String, Object>>
{
    INSTANCE{

        @Override
        public Map<String, Object> call() {
            TreeMap results = Maps.newTreeMap();
            try {
                long max = 0L;
                long active = 0L;
                for (String alias : ProxoolFacade.getAliases()) {
                    max = ProxoolFacade.getConnectionPoolDefinition((String)alias).getMaximumConnectionCount();
                    active = ProxoolFacade.getSnapshot((String)alias, (boolean)true).getActiveConnectionCount();
                    results.put(alias + ".MaxConnectionCount", max);
                    results.put(alias + ".ActiveConnectionCount", active);
                    results.put(alias + ".CapacityCheck", active < max ? "OK" : "FAILED");
                }
            }
            catch (Throwable f) {
                LOG.warn((Object)"Error getting proxool db connection information. Continuing.", f);
            }
            return results;
        }
    };

    private static final Logger LOG;

    static {
        LOG = Logger.getLogger(DbPoolSensor.class);
    }
}

