/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.component.Component;
import com.eucalyptus.component.Components;
import com.eucalyptus.stats.SystemMetric;
import com.eucalyptus.stats.sensors.EucalyptusStatsSensor;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class ComponentsSensor
implements EucalyptusStatsSensor {
    private static final Logger LOG = Logger.getLogger(ComponentsSensor.class);
    private static final long DEFAULT_TTL_SEC = 30L;
    private static final String STATE_NAME = "state";
    private String sensorName = "euca.components";
    private long ttl;
    private String description;
    private List<String> tags;
    private static final Predicate<Bootstrapper> RUN_CHECK = new Predicate<Bootstrapper>(){

        public boolean apply(@Nullable Bootstrapper bootstrapper) {
            try {
                return bootstrapper != null && bootstrapper.check();
            }
            catch (Throwable f) {
                LOG.trace((Object)("Bootstrapper check for " + bootstrapper.getProvides().getName() + " threw exception"), f);
                return false;
            }
        }
    };

    @Override
    public List<SystemMetric> poll() throws Exception {
        ArrayList results = Lists.newArrayList();
        for (Component comp : Components.listLocal()) {
            boolean result;
            String componentName = comp.getComponentId().getName();
            ArrayList<String> componentTags = new ArrayList<String>(this.tags.size() + 1);
            componentTags.addAll(this.tags);
            componentTags.add(comp.getLocalServiceConfiguration().getFullName().toString());
            SystemMetric stateOutput = new SystemMetric(this.sensorName + "." + componentName + "." + STATE_NAME, componentTags, "Component " + componentName + " state and health checks", new HashMap<String, Object>(), this.ttl);
            try {
                LOG.trace((Object)("Running check() on component: " + componentName + " for monitoring results"));
                result = Iterables.all((Iterable)comp.getBootstrappers(), RUN_CHECK);
            }
            catch (Throwable e) {
                LOG.fatal((Object)("Component " + componentName + " Check() call threw exception. Component may not be available for use"), e);
                result = false;
            }
            stateOutput.getValues().put("Check", result ? "OK" : "FAILED");
            try {
                LOG.trace((Object)("Getting state for component: " + componentName + " for monitoring results"));
                stateOutput.getValues().put("State", comp.getState().toString());
            }
            catch (Throwable e) {
                LOG.fatal((Object)("Component " + componentName + " getState() call threw exception. Component may not be available for use"), e);
            }
            results.add(stateOutput);
        }
        return results;
    }

    @Override
    public void init(String name, String description, List<String> defaultTags, long defaultTtl) throws Exception {
        this.sensorName = name;
        this.description = description;
        this.tags = defaultTags;
        this.ttl = defaultTtl;
    }

    @Override
    public String getName() {
        return this.sensorName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

