/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.sensors;

import com.eucalyptus.stats.SystemMetric;
import com.eucalyptus.stats.sensors.EucalyptusStatsSensor;
import com.eucalyptus.stats.sensors.MXBeanSensor;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class BaseStatsSensor
implements EucalyptusStatsSensor {
    protected static final Logger LOG = Logger.getLogger(MXBeanSensor.class);
    protected String sensorName;
    protected List<String> defaultTagsToApply;
    protected String defaultDescription;
    protected long defaultTtl;
    protected Callable<Map<String, Object>> valuesProvider;

    public static BaseStatsSensor buildSensor(String name, String description, List<String> defaultTags, long defaultTtl, Callable<Map<String, Object>> sensorCallable) throws Exception {
        BaseStatsSensor sensor = new BaseStatsSensor();
        sensor.init(name, description, defaultTags, defaultTtl, sensorCallable);
        return sensor;
    }

    @Override
    public String getName() {
        return this.sensorName;
    }

    public void setName(String sensorName) {
        this.sensorName = sensorName;
    }

    public List<String> getDefaultTagsToApply() {
        return this.defaultTagsToApply;
    }

    public void setDefaultTagsToApply(List<String> defaultTagsToApply) {
        this.defaultTagsToApply = defaultTagsToApply;
    }

    @Override
    public String getDescription() {
        return this.defaultDescription;
    }

    public void setDescription(String defaultDescription) {
        this.defaultDescription = defaultDescription;
    }

    public long getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(long defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    @Override
    public List<SystemMetric> poll() throws Exception {
        try {
            Map<String, Object> values = this.valuesProvider == null ? null : this.valuesProvider.call();
            SystemMetric m = new SystemMetric(this.getName(), this.getDefaultTagsToApply(), this.getDescription(), null, this.getDefaultTtl());
            m.setValues(values);
            return Lists.newArrayList((Object[])new SystemMetric[]{m});
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception caught invoking sensor. ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void init(String name, String description, List<String> defaultTags, long defaultTtl) throws Exception {
        this.sensorName = name;
        this.defaultTagsToApply = defaultTags;
        this.defaultDescription = description;
        this.defaultTtl = defaultTtl;
    }

    public void init(String name, String description, List<String> defaultTags, long defaultTtl, Callable<Map<String, Object>> sensorCallable) throws Exception {
        this.init(name, description, defaultTags, defaultTtl);
        this.valuesProvider = sensorCallable;
    }
}

