/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.emitters;

import com.eucalyptus.stats.SystemMetric;
import com.eucalyptus.stats.emitters.EventEmitter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoggingEventEmitter
implements EventEmitter {
    private static final Logger logger = Logger.getLogger(LoggingEventEmitter.class);
    private Level logLevel;

    public LoggingEventEmitter() {
        this(Level.INFO);
    }

    public LoggingEventEmitter(Level p) {
        this.logLevel = p;
    }

    @Override
    public boolean emit(SystemMetric event) {
        try {
            if (event == null) {
                return false;
            }
            logger.log((Priority)this.logLevel, (Object)event.toString());
            return true;
        }
        catch (Exception e) {
            logger.error((Object)"Failed to emit event!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean doesBatching() {
        return false;
    }

    @Override
    public void check() throws Exception {
    }
}

