/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats.emitters;

import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.stats.SystemMetric;
import com.eucalyptus.stats.emitters.EventEmitter;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;

public class FileSystemEmitter
implements EventEmitter {
    private static final Logger LOG = Logger.getLogger(FileSystemEmitter.class);
    private static SubDirectory defaultFsRoot = FileSystemEmitterConfiguration.dataOutputFSRoot;
    private Path fsRoot;
    private boolean isEnabled = false;

    public FileSystemEmitter() throws IOException {
        this(defaultFsRoot.toString());
    }

    public FileSystemEmitter(String rootPath) throws IOException {
        try {
            this.fsRoot = Paths.get(rootPath, new String[0]);
            FileSystemEmitterConfiguration.getGroup();
            this.isEnabled = true;
        }
        catch (Throwable e) {
            LOG.error((Object)("Eucalyptus stats event emitter cannot initialize because the user group " + FileSystemEmitterConfiguration.getStatusGroupName() + " is not found on the host. Please create the user group and restart the jvm process"));
            this.isEnabled = false;
            throw e;
        }
    }

    @Override
    public void check() throws Exception {
        try {
            FileSystemEmitterConfiguration.getGroup();
            this.isEnabled = true;
        }
        catch (Throwable e) {
            LOG.error((Object)("Eucalyptus stats event emitter cannot initialize because the user group " + FileSystemEmitterConfiguration.getStatusGroupName() + " is not found on the host. Please create the user group and restart the jvm process"));
            this.isEnabled = false;
            throw e;
        }
    }

    @Override
    public boolean emit(SystemMetric event) {
        if (!this.isEnabled || event == null) {
            return false;
        }
        try {
            String path = this.fsRoot + "/" + event.getSensor().replace('.', '/');
            Path filePath = FileSystems.getDefault().getPath(path, new String[0]);
            Path tmpPath = FileSystems.getDefault().getPath(path + ".new", new String[0]);
            try {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create file path for sensor output. Path='" + path + "'");
            }
            tmpPath = Files.createFile(tmpPath, PosixFilePermissions.asFileAttribute(FileSystemEmitterConfiguration.getDataFilePermissions()));
            Files.getFileAttributeView(tmpPath, PosixFileAttributeView.class, new LinkOption[0]).setGroup(FileSystemEmitterConfiguration.getGroup());
            BufferedWriter fileOut = Files.newBufferedWriter(tmpPath, StandardCharsets.UTF_8, new OpenOption[0]);
            fileOut.write(event.toString());
            fileOut.close();
            Files.move(tmpPath, filePath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed emitting event to file", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean doesBatching() {
        return false;
    }

    @ConfigurableClass(root="stats.file_system_emitter", description="Configuration for the stats emitter that sends data to local filesystem on host")
    static class FileSystemEmitterConfiguration {
        private static final String STATUS_USER_GROUP_PROPERTY_NAME = "euca.stats_group";
        private static final String STATUS_DATA_FILE_PERMS_PROPERTY_NAME = "euca.stats_data_perms";
        private static final String STATUS_USER_GROUP_PROPERTY_DEFAULT = "eucalyptus-status";
        private static final String DEFAULT_GROUP_PERM_STRING = "rw-r-----";
        @ConfigurableField(displayName="stats group name", description="group name that owns stats data files", initial="eucalyptus-status")
        public static String stats_group_name = "eucalyptus-status";
        @ConfigurableField(displayName="stats_data_group_permissions", description="group permissions to place on stats data files in string form. eg. rwxr-x--x", initial="rw-r-----")
        public static String stats_data_permissions = "rw-r-----";
        public static SubDirectory dataOutputFSRoot = SubDirectory.STATUS;
        private static final Integer memoizationExpirationSeconds = 10;
        private static Supplier<Set<PosixFilePermission>> OUTPUT_FILE_PERMS_SUPPLIER = FileSystemEmitterConfiguration.getOutputFilePermSupplier();
        private static Supplier<GroupPrincipal> GROUP_SUPPLIER = FileSystemEmitterConfiguration.getGroupSupplier();

        FileSystemEmitterConfiguration() {
        }

        public static String getStatusGroupName() {
            return System.getProperty(STATUS_USER_GROUP_PROPERTY_NAME, stats_group_name);
        }

        public static Set<PosixFilePermission> getDataFilePermissions() {
            return (Set)OUTPUT_FILE_PERMS_SUPPLIER.get();
        }

        public static GroupPrincipal getGroup() {
            return (GroupPrincipal)GROUP_SUPPLIER.get();
        }

        public static void forceConfigRefresh() {
            OUTPUT_FILE_PERMS_SUPPLIER = FileSystemEmitterConfiguration.getOutputFilePermSupplier();
            GROUP_SUPPLIER = FileSystemEmitterConfiguration.getGroupSupplier();
        }

        private static Supplier<Set<PosixFilePermission>> getOutputFilePermSupplier() {
            return Suppliers.memoizeWithExpiration((Supplier)new Supplier<Set<PosixFilePermission>>(){

                public Set<PosixFilePermission> get() {
                    return PosixFilePermissions.fromString(System.getProperty(FileSystemEmitterConfiguration.STATUS_DATA_FILE_PERMS_PROPERTY_NAME, stats_data_permissions));
                }
            }, (long)memoizationExpirationSeconds.intValue(), (TimeUnit)TimeUnit.SECONDS);
        }

        private static Supplier<GroupPrincipal> getGroupSupplier() {
            return Suppliers.memoizeWithExpiration((Supplier)new Supplier<GroupPrincipal>(){

                public GroupPrincipal get() {
                    try {
                        return FileSystemEmitterConfiguration.verifyUserGroup(FileSystemEmitterConfiguration.getStatusGroupName(), Paths.get(dataOutputFSRoot.toString(), new String[0]));
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Cannot use group name " + FileSystemEmitterConfiguration.getStatusGroupName() + " for stats output. Invalid name or group not found"), (Throwable)e);
                        throw Exceptions.toUndeclared((String)"Invalid group name. Not found", (Throwable[])new IOException[]{e});
                    }
                }
            }, (long)memoizationExpirationSeconds.intValue(), (TimeUnit)TimeUnit.SECONDS);
        }

        private static GroupPrincipal verifyUserGroup(@Nonnull String groupName, @Nonnull Path fileSystemRoot) throws IOException {
            try {
                return fileSystemRoot.getFileSystem().getUserPrincipalLookupService().lookupPrincipalByGroupName(groupName);
            }
            catch (IOException e) {
                LOG.error((Object)("Could not get group information for user group " + FileSystemEmitterConfiguration.getStatusGroupName() + " from filesystem " + fileSystemRoot.toString()), (Throwable)e);
                throw e;
            }
        }
    }
}

