/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sf.json.JSONObject;

public class SystemMetric {
    private TreeMap<String, Object> values;
    private long timestamp;
    private long ttl;
    private String sensor;
    private List<String> tags;
    private String description;

    public SystemMetric(String name, List<String> tagsToUse, String desc, Map<String, Object> sensorValues, long eventTimestamp, long eventTtl) {
        this.setSensor(name);
        this.setTags(tagsToUse);
        this.setDescription(desc);
        this.setValues(sensorValues);
        this.setTimestamp(eventTimestamp);
        this.setTtl(eventTtl);
    }

    public SystemMetric(String serv, List<String> tagsToUse, String desc, Map<String, Object> metricValues, long eventTtl) {
        this(serv, tagsToUse, desc, metricValues, System.currentTimeMillis() / 1000L, eventTtl);
    }

    public String toString() {
        JSONObject obj = new JSONObject();
        obj.accumulate("timestamp", this.timestamp);
        obj.accumulate("sensor", (Object)this.sensor);
        obj.accumulate("description", (Object)this.description);
        obj.accumulate("tags", this.tags);
        obj.accumulate("values", this.values);
        obj.accumulate("ttl", this.ttl);
        return obj.toString(4);
    }

    public String getSensor() {
        return this.sensor;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTtl() {
        return this.ttl;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setSensor(String sensor) {
        this.sensor = sensor;
    }

    public void setTags(List<String> tags) {
        if (tags != null) {
            this.tags = Lists.newArrayList(tags);
            Collections.sort(this.tags);
        } else {
            this.tags = Lists.newArrayList();
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Object> sensorValues) {
        this.values = Maps.newTreeMap();
        if (sensorValues != null) {
            this.values.putAll(sensorValues);
        }
    }
}

