/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats;

import com.eucalyptus.bootstrap.OrderedShutdown;
import com.eucalyptus.stats.EventEmitterService;
import com.eucalyptus.stats.SensorManager;
import com.eucalyptus.stats.configuration.StatsConfiguration;
import com.eucalyptus.stats.sensors.SensorManagers;
import org.apache.log4j.Logger;

public class StatsManager {
    private static final Logger LOG = Logger.getLogger(StatsManager.class);
    protected static final Runnable monitoringShutdownHook = new Runnable(){

        @Override
        public void run() {
            int retryCount = 3;
            for (int i = 0; i < retryCount; ++i) {
                try {
                    StatsManager.stop();
                    break;
                }
                catch (Throwable f) {
                    LOG.warn((Object)"Error shutting down monitoring system", f);
                    continue;
                }
            }
        }
    };

    public static void init() throws Exception {
        LOG.info((Object)"Initializing monitoring system");
        if (!StatsConfiguration.isStatsReportingEnabled().booleanValue()) {
            LOG.warn((Object)"Skipping monitoring configuration because it is explicitly disabled");
            return;
        }
        try {
            EventEmitterService.getInstance().init();
            SensorManagers.getInstance().init(EventEmitterService.getInstance());
            OrderedShutdown.registerPreShutdownHook((Runnable)monitoringShutdownHook);
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing monitoring service.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static SensorManager getSensorManager() {
        return SensorManagers.getInstance();
    }

    public static void start() throws Exception {
        if (!StatsConfiguration.isStatsReportingEnabled().booleanValue()) {
            LOG.warn((Object)"Skipping monitoring startup because it is explicitly disabled");
        } else {
            LOG.info((Object)"Starting monitoring system");
            EventEmitterService.getInstance().start();
            SensorManagers.getInstance().start();
        }
    }

    public static void stop() throws Exception {
        SensorManagers.getInstance().stop();
        EventEmitterService.getInstance().start();
    }

    public static void check() throws Exception {
        try {
            SensorManagers.getInstance().check();
            EventEmitterService.getInstance().check();
        }
        catch (Exception e) {
            LOG.error((Object)"Stats subsystem failed check() call");
            throw e;
        }
    }
}

