/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats;

import com.eucalyptus.scripting.Groovyness;
import com.eucalyptus.stats.EventEmitterService;
import com.eucalyptus.stats.SensorEntry;
import com.eucalyptus.stats.SensorManager;
import com.eucalyptus.stats.StatsManager;
import com.eucalyptus.stats.SystemMetric;
import com.eucalyptus.stats.configuration.StatsConfiguration;
import com.eucalyptus.system.SubDirectory;
import com.eucalyptus.util.Exceptions;
import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.apache.log4j.Logger;

@Singleton
public class SensorManagerImpl
implements SensorManager {
    private static final Logger LOG = Logger.getLogger(SensorManagerImpl.class);
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(StatsConfiguration.getMonitoringThreadPoolSize());
    private final List<SensorEntry> sensorList = new ArrayList<SensorEntry>(50);
    private static final long initialDelaySeconds = 0L;
    private EventEmitterService emitterService;
    final Runnable CONFIG_CHECK_TASK = new Runnable(){
        FileTime lastModTime;

        @Override
        public void run() {
            if (this.configChanged()) {
                int failCount = 3;
                long retryBackoffMs = 2000L;
                for (int i = 0; i < failCount; ++i) {
                    try {
                        LOG.info((Object)("Initiating stats manager reload due to configuration change. Attempt " + (i + 1) + " of " + failCount));
                        StatsManager.stop();
                        StatsManager.start();
                        LOG.info((Object)"Completed stats manager reload due triggered from configuration change");
                        return;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Error reloading the stats manager on configuration update. Waiting " + retryBackoffMs + "ms before next retry"));
                        if (i >= failCount - 1) break;
                        try {
                            Thread.sleep(retryBackoffMs);
                            continue;
                        }
                        catch (InterruptedException intEx) {
                            LOG.fatal((Object)"Sleep interrupted. Aborting retyr process for reload of stats manager");
                            return;
                        }
                    }
                }
                try {
                    LOG.error((Object)("Exceeded max retries for stats manager reload: " + failCount + ". Disabling the stats manager"));
                    StatsManager.stop();
                }
                catch (Exception e) {
                    LOG.error((Object)"Unexpected failure stopping stats manager in failure path of reload. There is a problem with the stats system. Please examine configuration", (Throwable)e);
                }
            }
        }

        private boolean configChanged() {
            String configFile = StatsConfiguration.getSensorConfigScript();
            try {
                FileTime modTime = Files.getLastModifiedTime(Paths.get(configFile, new String[0]), new LinkOption[0]);
                return modTime.compareTo(this.lastModTime) > 0;
            }
            catch (Exception e) {
                LOG.error((Object)("Could not verify last modified time of senosr configuration file " + configFile + ". Failing config change check."));
                return false;
            }
        }

        private void scheduleNextCheck() throws Exception {
            SensorManagerImpl.this.executorService.schedule(this, (long)StatsConfiguration.getConfigCheckInterval(), TimeUnit.SECONDS);
        }
    };

    @Override
    public void check() {
        if (this.executorService == null || this.sensorList == null || this.emitterService == null) {
            throw Exceptions.toUndeclared((String)"SensorManager not ready", (Throwable[])new Throwable[0]);
        }
    }

    @Override
    public void pollAll() {
        for (SensorEntry e : this.sensorList) {
            this.buildMetricQueryRunnable(e).run();
        }
    }

    @Override
    public List<SystemMetric> getMetrics() {
        ArrayList metrics = Lists.newArrayList();
        for (SensorEntry e : this.sensorList) {
            try {
                metrics.addAll(e.getSensor().poll());
            }
            catch (Throwable f) {
                LOG.warn((Object)("Error polling sensor: " + e.getSensor().getName()), f);
            }
        }
        return metrics;
    }

    private static List<SensorEntry> getSensorList() {
        LOG.info((Object)("Reloading sensor list from: " + StatsConfiguration.sensorCodeDirectory.toString() + "/" + StatsConfiguration.getSensorConfigScript()));
        try {
            return (List)Groovyness.run((SubDirectory)StatsConfiguration.sensorCodeDirectory, (String)StatsConfiguration.getSensorConfigScript());
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load sensor list groovy script", (Throwable)e);
            return null;
        }
    }

    @Override
    public void start() {
        this.executorService.execute(this.CONFIG_CHECK_TASK);
        for (SensorEntry sensor : this.sensorList) {
            LOG.info((Object)("Adding sensor to schedule: " + sensor.getSensor().getName() + " Interval = " + sensor.getQueryInterval()));
            this.executorService.scheduleAtFixedRate(this.buildMetricQueryRunnable(sensor), 0L, sensor.getQueryInterval(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void stop() {
        this.executorService.shutdownNow();
    }

    @Override
    public synchronized void init(EventEmitterService eventEmitter) {
        List<SensorEntry> sensors = SensorManagerImpl.getSensorList();
        if (sensors == null) {
            throw new RuntimeException("Error reloading sensor list. No sensor changes made.");
        }
        this.sensorList.clear();
        this.emitterService = eventEmitter;
        this.sensorList.addAll(sensors);
    }

    @Override
    public EventEmitterService getEventEmitterService() {
        return this.emitterService;
    }

    private Runnable buildMetricQueryRunnable(final SensorEntry sensor) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    List<SystemMetric> result = sensor.getSensor().poll();
                    try {
                        for (SystemMetric m : result) {
                            SensorManagerImpl.this.emitterService.offer(m);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Sensor ran, but emitting event failed.", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Sensor failed to execute: " + sensor), (Throwable)e);
                }
            }
        };
    }

    public synchronized void reload() {
        this.stop();
        this.init(this.emitterService);
    }
}

