/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.stats;

import com.eucalyptus.stats.SystemMetric;
import com.eucalyptus.stats.configuration.StatsConfiguration;
import com.eucalyptus.stats.emitters.EventEmitter;
import com.eucalyptus.util.Exceptions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.log4j.Logger;

public class EventEmitterService {
    private static final Logger LOG = Logger.getLogger(EventEmitterService.class);
    protected LinkedBlockingQueue<SystemMetric> eventQueue = new LinkedBlockingQueue();
    protected ScheduledExecutorService writerThreadPool = Executors.newSingleThreadScheduledExecutor();
    protected volatile boolean acceptNewEvents = false;
    private static EventEmitterService serviceInstance;

    public static synchronized EventEmitterService getInstance() {
        if (serviceInstance == null) {
            serviceInstance = new EventEmitterService();
        }
        return serviceInstance;
    }

    public void init() {
    }

    public void start() {
        this.acceptNewEvents = true;
        this.writerThreadPool.execute(new EventWriterThread(this.eventQueue, EventEmitterService.getEmitterInstance()));
    }

    public void check() throws Exception {
        if (this.eventQueue == null || this.writerThreadPool == null || this.writerThreadPool.isShutdown() || this.writerThreadPool.isTerminated() || EventEmitterService.getEmitterInstance() == null) {
            throw new Exception("Event emitter check failed. Event emitter service not ready");
        }
        try {
            EventEmitterService.getEmitterInstance().check();
        }
        catch (Exception e) {
            LOG.error((Object)"Event emitter service failed check because of exception from emitter instance", (Throwable)e);
            throw new Exception("Event emitter service not ready", e);
        }
    }

    protected static EventEmitter getEmitterInstance() {
        try {
            Class emitterClass = StatsConfiguration.getEmitterClass();
            return (EventEmitter)emitterClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not load event emitter config, cannot initialize the monitoring system", (Throwable)e);
            throw Exceptions.toUndeclared((String)"Error loading emitter configuration", (Throwable[])new Exception[]{e});
        }
    }

    public boolean offer(SystemMetric systemMetric) {
        return this.acceptNewEvents && this.eventQueue.offer(systemMetric);
    }

    public void stop() {
        this.acceptNewEvents = false;
        this.writerThreadPool.shutdownNow();
    }

    protected void softStop() {
        this.acceptNewEvents = false;
        while (!this.eventQueue.isEmpty()) {
        }
        this.writerThreadPool.shutdown();
    }

    private class EventWriterThread
    implements Runnable {
        BlockingQueue<SystemMetric> eventQ;
        EventEmitter emitter;

        public EventWriterThread(BlockingQueue<SystemMetric> eventQueueToWatch, EventEmitter eventEmitter) {
            this.eventQ = eventQueueToWatch;
            this.emitter = eventEmitter;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    SystemMetric event = this.eventQ.take();
                    this.emitter.emit(event);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Event emitter interrupted");
                return;
            }
        }
    }
}

