/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.Faults;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.records.Logs;
import com.eucalyptus.stats.StatsManager;
import com.eucalyptus.troubleshooting.changelisteners.DBCheckPollTimeListener;
import com.eucalyptus.troubleshooting.changelisteners.DBCheckThresholdListener;
import com.eucalyptus.troubleshooting.changelisteners.LogFileDiskCheckPollTimeListener;
import com.eucalyptus.troubleshooting.changelisteners.LogFileDiskCheckThresholdListener;
import com.eucalyptus.troubleshooting.changelisteners.LogLevelListener;
import com.eucalyptus.troubleshooting.changelisteners.MemoryCheckPollTimeListener;
import com.eucalyptus.troubleshooting.changelisteners.MemoryCheckRatioListener;
import com.eucalyptus.troubleshooting.changelisteners.PermGenMemoryCheckPollTimeListener;
import com.eucalyptus.troubleshooting.changelisteners.PermGenMemoryCheckRatioListener;
import com.eucalyptus.troubleshooting.changelisteners.TriggerFaultListener;
import com.eucalyptus.troubleshooting.checker.schedule.DBCheckScheduler;
import com.eucalyptus.troubleshooting.checker.schedule.LogFileDiskCheckScheduler;
import com.eucalyptus.troubleshooting.checker.schedule.MemoryCheckScheduler;
import com.eucalyptus.troubleshooting.checker.schedule.PermGenMemoryCheckScheduler;
import org.apache.log4j.Logger;

@Provides(value=Empyrean.class)
@RunDuring(value=Bootstrap.Stage.CloudServiceInit)
@ConfigurableClass(root="cloud", description="Parameters controlling troubleshooting information.")
public class TroubleshootingBootstrapper
extends Bootstrapper {
    private static final Logger LOG = Logger.getLogger(TroubleshootingBootstrapper.class);
    @ConfigurableField(description="Poll time (ms) for log file disk check", initial="5000", changeListener=LogFileDiskCheckPollTimeListener.class, displayName="log.file.disk.check.poll.time")
    public static String LOG_FILE_DISK_CHECK_POLL_TIME = "5000";
    @ConfigurableField(description="Threshold (bytes or %) for log file disk check", initial="2.0%", changeListener=LogFileDiskCheckThresholdListener.class, displayName="log.file.disk.check.threshold")
    public static String LOG_FILE_DISK_CHECK_THRESHOLD = "2.0%";
    @ConfigurableField(description="Poll time (ms) for db connection check", initial="60000", changeListener=DBCheckPollTimeListener.class, displayName="db.check.poll.time")
    public static String DB_CHECK_POLL_TIME = "60000";
    @ConfigurableField(description="Threshold (num connections or %) for db connection check", initial="2.0%", changeListener=DBCheckThresholdListener.class, displayName="db.check.threshold")
    public static String DB_CHECK_THRESHOLD = "2.0%";
    @ConfigurableField(description="Poll time (ms) for perm-gen memory check", initial="5000", changeListener=PermGenMemoryCheckPollTimeListener.class, displayName="perm.gen.memory.check.poll.time")
    public static String PERM_GEN_MEMORY_CHECK_POLL_TIME = "5000";
    @ConfigurableField(description="Ratio (of used memory) for perm-gen memory check", initial="0.98", changeListener=PermGenMemoryCheckRatioListener.class, displayName="perm.gen.memory.check.ratio")
    public static String PERM_GEN_MEMORY_CHECK_RATIO = "0.98";
    @ConfigurableField(description="Poll time (ms) for memory check", initial="5000", changeListener=MemoryCheckPollTimeListener.class, displayName="memory.check.poll.time")
    public static String MEMORY_CHECK_POLL_TIME = "5000";
    @ConfigurableField(description="Ratio (of post-garbage collected old-gen memory) for memory check", initial="0.98", changeListener=MemoryCheckRatioListener.class, displayName="memory.check.ratio")
    public static String MEMORY_CHECK_RATIO = "0.98";
    @ConfigurableField(description="Fault id last used to trigger test", initial="", changeListener=TriggerFaultListener.class, displayName="trigger.fault")
    public static String TRIGGER_FAULT = "";
    @ConfigurableField(description="Log level for dynamic override.", initial="", changeListener=LogLevelListener.class, displayName="euca.log.level")
    public static String EUCA_LOG_LEVEL = Logs.isExtrrreeeme() ? "EXTREME" : System.getProperty("euca.log.level", "");

    public boolean load() throws Exception {
        LOG.info((Object)"Loading troubleshooting interface.");
        return true;
    }

    public boolean start() throws Exception {
        LOG.info((Object)"Starting troubleshooting interface.");
        LogFileDiskCheckScheduler.resetLogFileDiskCheck();
        DBCheckScheduler.resetDBCheck();
        PermGenMemoryCheckScheduler.resetMXBeanMemoryCheck();
        MemoryCheckScheduler.memoryCheck();
        Faults.init();
        LOG.info((Object)"Starting monitoring interface");
        try {
            StatsManager.init();
            StatsManager.start();
        }
        catch (Throwable f) {
            LOG.fatal((Object)"Could not initialize and start the monitoring interface. Failing bootstrap", f);
            throw f;
        }
        return true;
    }

    public boolean enable() throws Exception {
        return true;
    }

    public boolean stop() throws Exception {
        LOG.info((Object)"Stopping troubleshooting interface");
        StatsManager.stop();
        return true;
    }

    public void destroy() throws Exception {
    }

    public boolean disable() throws Exception {
        return true;
    }

    public boolean check() throws Exception {
        try {
            StatsManager.check();
        }
        catch (Exception e) {
            LOG.error((Object)"Stat manager failed check. Failing Troubleshooting check call as well.", (Throwable)e);
            return false;
        }
        return true;
    }
}

