/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.common;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;

public class AutoScalingResourceName {
    private static final String prefix = "arn:aws:";
    private static final Splitter nameSpliter = Splitter.on((char)':');
    private static final int PART_SERVICE = 2;
    private static final int PART_NAMESPACE = 4;
    private static final int PART_RELATIVE_ID_TYPE = 5;
    private static final int PART_RELATIVE_ID_UUID = 6;
    private static final int PART_RELATIVE_NAME_1 = 7;
    private static final int PART_RELATIVE_NAME_2 = 8;
    private final String resourceName;
    private final String service;
    private final String namespace;
    private final String type;
    private final String uuid;
    private final String name1;
    @Nullable
    private final String name2;

    public AutoScalingResourceName(String resourceName, String service, String namespace, String type, String uuid, String name1, @Nullable String name2) {
        this.resourceName = resourceName;
        this.service = service;
        this.namespace = namespace;
        this.type = type;
        this.uuid = uuid;
        this.name1 = this.toValue(name1);
        this.name2 = this.toValue(name2);
    }

    public static AutoScalingResourceName parse(String resourceName) throws InvalidResourceNameException {
        return AutoScalingResourceName.parse(resourceName, null);
    }

    public static AutoScalingResourceName parse(String resourceName, @Nullable Type type) throws InvalidResourceNameException {
        if (!resourceName.startsWith(prefix)) {
            throw new InvalidResourceNameException(resourceName);
        }
        Iterable nameParts = nameSpliter.split((CharSequence)resourceName);
        int namePartCount = Iterables.size((Iterable)nameParts);
        if (namePartCount < 8 || namePartCount > 9) {
            throw new InvalidResourceNameException(resourceName);
        }
        if (!"autoscaling".equals(Iterables.get((Iterable)nameParts, (int)2))) {
            throw new InvalidResourceNameException(resourceName);
        }
        if (type != null && !type.name().equals(Iterables.get((Iterable)nameParts, (int)5))) {
            throw new InvalidResourceNameException(resourceName);
        }
        return new AutoScalingResourceName(resourceName, (String)Iterables.get((Iterable)nameParts, (int)2), (String)Iterables.get((Iterable)nameParts, (int)4), (String)Iterables.get((Iterable)nameParts, (int)5), (String)Iterables.get((Iterable)nameParts, (int)6), (String)Iterables.get((Iterable)nameParts, (int)7), namePartCount > 8 ? (String)Iterables.get((Iterable)nameParts, (int)8) : null);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getService() {
        return this.service;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getType() {
        return this.type;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getScope(Type type) {
        if (!type.isScoped()) {
            throw new IllegalStateException("Type not scoped");
        }
        return this.name1;
    }

    public String getName(Type type) {
        if (type.isScoped()) {
            if (this.name2 == null) {
                throw new InvalidResourceNameException(this.resourceName);
            }
            return this.name2;
        }
        return this.name1;
    }

    public String toString() {
        return this.resourceName;
    }

    public static Set<String> simpleNames(Iterable<String> namesAndArns) {
        return Sets.newHashSet((Iterable)Iterables.filter(namesAndArns, (Predicate)Predicates.not(AutoScalingResourceName.isResourceName())));
    }

    public static Set<String> arns(Iterable<String> namesAndArns) {
        return Sets.newHashSet((Iterable)Iterables.filter(namesAndArns, AutoScalingResourceName.isResourceName()));
    }

    public static Predicate<String> isResourceName() {
        return ResourceNamePredicate.INSTANCE;
    }

    private String toValue(String name) {
        String value = null;
        if (name != null) {
            int slashIndex = name.indexOf(47);
            if (slashIndex <= 0 || slashIndex == name.length() - 1) {
                throw new InvalidResourceNameException(this.resourceName);
            }
            value = name.substring(slashIndex + 1);
        }
        return value;
    }

    public static final class InvalidResourceNameException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidResourceNameException(String resourceName) {
            super("Invalid resource name: " + resourceName);
        }
    }

    private static enum ResourceNamePredicate implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String value) {
            return value != null && value.startsWith(AutoScalingResourceName.prefix);
        }
    }

    public static enum Type {
        launchConfiguration("launch configuration", false),
        autoScalingGroup("auto scaling group", false),
        scalingPolicy("scaling policy", true);

        private final String description;
        private final boolean scoped;

        private Type(String description, boolean scoped) {
            this.description = description;
            this.scoped = scoped;
        }

        public String describe() {
            return this.description;
        }

        public boolean isScoped() {
            return this.scoped;
        }
    }
}

