/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.common;

import com.eucalyptus.autoscaling.common.AutoScalingMetadata;
import com.eucalyptus.autoscaling.common.AutoScalingResourceName;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Set;

public class AutoScalingMetadatas
extends RestrictedTypes {
    public static <T extends AutoScalingMetadata.AutoScalingMetadataWithResourceName> Function<T, String> toArn() {
        return new Function<T, String>(){

            public String apply(T metadata) {
                return metadata == null ? null : metadata.getArn();
            }
        };
    }

    public static <T extends AutoScalingMetadata.AutoScalingMetadataWithResourceName> Predicate<T> filterByArn(Collection<String> requestedArns) {
        return AutoScalingMetadatas.filterByProperty(requestedArns, AutoScalingMetadatas.toArn());
    }

    public static <T extends AutoScalingMetadata.AutoScalingMetadataWithResourceName> Predicate<T> filterPrivilegesByIdOrArn(Class<T> metadataClass, Collection<String> requestedItems) {
        Set<String> names = AutoScalingResourceName.simpleNames(requestedItems);
        Set<String> arns = AutoScalingResourceName.arns(requestedItems);
        return Predicates.and((Predicate)(!arns.isEmpty() && !names.isEmpty() ? Predicates.or((Predicate)AutoScalingMetadatas.filterById(names), AutoScalingMetadatas.filterByArn(arns)) : (!arns.isEmpty() ? AutoScalingMetadatas.filterByArn(arns) : AutoScalingMetadatas.filterById(names))), (Predicate)RestrictedTypes.filteringFor(metadataClass).byPrivileges().buildPredicate());
    }
}

