/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.autoscaling.common;

import com.eucalyptus.system.Ats;
import com.eucalyptus.util.MessageValidation;
import com.eucalyptus.util.Pair;
import edu.ucsb.eucalyptus.msgs.EucalyptusData;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.regex.Pattern;

public class AutoScalingMessageValidation {

    public static enum FieldRegexValue {
        STRING_128("(?s).{1,128}"),
        STRING_256("(?s).{1,256}"),
        UUID_VERBOSE("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}|verbose"),
        ADJUSTMENT("ChangeInCapacity|ExactCapacity|PercentChangeInCapacity"),
        NAME("[ -9;-\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff\r\n\t]{1,255}"),
        ARN("arn:aws:autoscaling:[ -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff\r\n\t]{1,1580}"),
        NAME_OR_ARN("[ -9;-\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff\r\n\t]{1,255}|arn:aws:autoscaling:[ -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff\r\n\t]{1,1580}"),
        HEALTH_CHECK("ELB|EC2"),
        HEALTH_STATUS("Healthy|Unhealthy"),
        METRIC("GroupMinSize|GroupMaxSize|GroupDesiredCapacity|GroupInServiceInstances|GroupPendingInstances|GroupTerminatingInstances|GroupTotalInstances"),
        METRIC_GRANULARITY("1Minute"),
        SCALING_PROCESS("Launch|Terminate|HealthCheck|ReplaceUnhealthy|AZRebalance|AlarmNotification|ScheduledActions|AddToLoadBalancer"),
        TAG_FILTER("auto-scaling-group|key|value|propagate-at-launch"),
        TAG_RESOURCE("auto-scaling-group"),
        TERMINATION_POLICY("OldestInstance|NewestInstance|OldestLaunchConfiguration|ClosestToNextInstanceHour|Default"),
        VPC_ZONE_IDENTIFIER("subnet-[0-9a-fA-F]{8}(?: *, *subnet-[0-9a-fA-F]{8})*"),
        EC2_NAME("(?s).{1,255}"),
        EC2_MACHINE_IMAGE("[ae]mi-[0-9a-fA-F]{8}"),
        EC2_KERNEL_IMAGE("[ae]ki-[0-9a-fA-F]{8}"),
        EC2_RAMDISK_IMAGE("[ae]ri-[0-9a-fA-F]{8}"),
        EC2_SNAPSHOT("snap-[0-9a-fA-F]{8}"),
        EC2_INSTANCE("i-[0-9a-fA-F]{8}"),
        EC2_INSTANCE_VERBOSE("i-[0-9a-fA-F]{8}|verbose"),
        EC2_USERDATA("(?s).{0,90000}"),
        EC2_SPOT_PRICE("[0-9]{1,4}\\.[0-9]{2,4}"),
        EC2_PLACEMENT_TENANCY("default|dedicated"),
        ELB_NAME("(?s).{1,255}"),
        IAM_NAME_OR_ARN("[a-zA-Z0-9+=,.@-]{1,128}|arn:aws:iam:[!-~]{1,1588}");

        private final Pattern pattern;

        private FieldRegexValue(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public Pattern pattern() {
            return this.pattern;
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRange {
        public long min() default 0L;

        public long max() default 0x7FFFFFFFFFFFFFFFL;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface FieldRegex {
        public FieldRegexValue value();
    }

    public static class AutoScalingMessageValidationAssistant
    implements MessageValidation.ValidationAssistant {
        public boolean validate(Object object) {
            return object instanceof EucalyptusData;
        }

        public Pair<Long, Long> range(Ats ats) {
            FieldRange range = (FieldRange)ats.get(FieldRange.class);
            return range == null ? null : Pair.pair((Object)range.min(), (Object)range.max());
        }

        public Pattern regex(Ats ats) {
            FieldRegex regex = (FieldRegex)ats.get(FieldRegex.class);
            return regex == null ? null : regex.value().pattern();
        }
    }
}

