/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.www;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.AuthenticationProperties;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.Certificate;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.autoscaling.common.AutoScaling;
import com.eucalyptus.bootstrap.Host;
import com.eucalyptus.bootstrap.Hosts;
import com.eucalyptus.cloudformation.CloudFormation;
import com.eucalyptus.cloudwatch.common.CloudWatch;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceBuilder;
import com.eucalyptus.component.ServiceBuilders;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Euare;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.component.id.Tokens;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.PEMFiles;
import com.eucalyptus.loadbalancing.common.LoadBalancing;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.simpleworkflow.common.SimpleWorkflow;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.Internets;
import com.eucalyptus.ws.StackConfiguration;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.log4j.Logger;

public class X509Download
extends HttpServlet {
    private static Logger LOG = Logger.getLogger(X509Download.class);
    public static String NAME_SHORT = "euca2";
    public static String PARAMETER_USERNAME = "user";
    public static String PARAMETER_ACCOUNTNAME = "account";
    public static String PARAMETER_KEYNAME = "keyName";
    public static String PARAMETER_CODE = "code";
    public static String PARAMETER_FORCE = "force";

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String code = request.getParameter(PARAMETER_CODE);
        String userName = request.getParameter(PARAMETER_USERNAME);
        String accountName = request.getParameter(PARAMETER_ACCOUNTNAME);
        String mimetype = "application/zip";
        if (accountName == null || "".equals(accountName)) {
            X509Download.hasError(400, "No account name provided", response);
            return;
        }
        if (userName == null || "".equals(userName)) {
            X509Download.hasError(400, "No user name provided", response);
            return;
        }
        if (code == null || "".equals(code)) {
            X509Download.hasError(400, "Wrong user security code", response);
            return;
        }
        User user = null;
        try {
            Account account = Accounts.lookupAccountByName((String)accountName);
            user = account.lookupUserByName(userName);
            if (!user.isEnabled().booleanValue() || !User.RegistrationStatus.CONFIRMED.equals((Object)user.getRegistrationStatus())) {
                X509Download.hasError(403, "Access is not authorized", response);
                return;
            }
        }
        catch (AuthException e) {
            X509Download.hasError(400, "User does not exist", response);
            return;
        }
        catch (Exception e) {
            X509Download.hasError(500, "Fail to retrieve user data", response);
            return;
        }
        try {
            if (!code.equals(user.resetToken())) {
                X509Download.hasError(403, "Access is not authorized", response);
                return;
            }
        }
        catch (Exception e) {
            X509Download.hasError(500, "Can not reset user security code", response);
            return;
        }
        response.setContentType(mimetype);
        response.setHeader("Content-Disposition", "attachment; filename=\"" + NAME_SHORT + "-" + userName + "-x509.zip\"");
        LOG.info((Object)("pushing out the X509 certificate for user " + userName));
        byte[] x509zip = null;
        try {
            x509zip = X509Download.getX509Zip(user, "true".equals(request.getParameter(PARAMETER_FORCE)));
        }
        catch (Exception e) {
            LOG.debug((Object)e, (Throwable)e);
            X509Download.hasError(500, "Fail to return user credentials", response);
            return;
        }
        try {
            ServletOutputStream op = response.getOutputStream();
            response.setContentLength(x509zip.length);
            op.write(x509zip);
            op.flush();
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
        }
    }

    public static void hasError(int statusCode, String message, HttpServletResponse response) {
        try {
            response.setStatus(statusCode);
            response.setContentType("text/plain; charset=utf-8");
            response.getWriter().print(X509Download.getError(message));
            response.getWriter().flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] getX509Zip(User u, boolean force) throws Exception {
        String fingerPrint;
        X509Certificate cloudCert = null;
        X509Certificate x509 = null;
        String userAccessKey = null;
        String userSecretKey = null;
        KeyPair keyPair = null;
        try {
            List accessKeys = u.getKeys();
            for (AccessKey k : accessKeys) {
                if (!k.isActive().booleanValue()) continue;
                userAccessKey = k.getAccessKey();
                userSecretKey = k.getSecretKey();
            }
            if (userAccessKey == null && (accessKeys.isEmpty() || u.isSystemAdmin() && force || accessKeys.size() < AuthenticationProperties.ACCESS_KEYS_LIMIT)) {
                AccessKey k = u.createKey();
                userAccessKey = k.getAccessKey();
                userSecretKey = k.getSecretKey();
            }
            if (userAccessKey == null) {
                throw new IllegalStateException("Access key limit exceeded");
            }
            AuthenticationProperties.CredentialDownloadGenerateCertificateStrategy certificateStrategy = AuthenticationProperties.getCredentialDownloadGenerateCertificateStrategy();
            int nonRevokedCertificateCount = Iterables.size((Iterable)Iterables.filter((Iterable)u.getCertificates(), (Predicate)CollectionUtils.propertyPredicate((Object)false, (Function)Certificate.Util.revoked())));
            if (certificateStrategy == AuthenticationProperties.CredentialDownloadGenerateCertificateStrategy.Absent && nonRevokedCertificateCount == 0 || certificateStrategy == AuthenticationProperties.CredentialDownloadGenerateCertificateStrategy.Limited && nonRevokedCertificateCount < AuthenticationProperties.SIGNING_CERTIFICATES_LIMIT) {
                keyPair = Certs.generateKeyPair();
                x509 = Certs.generateCertificate((KeyPair)keyPair, (String)u.getName());
                x509.checkValidity();
                u.addCertificate(x509);
            }
            cloudCert = SystemCredentials.lookup(Eucalyptus.class).getCertificate();
        }
        catch (Exception e) {
            LOG.fatal((Object)e, (Throwable)e);
            throw e;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream((OutputStream)byteOut);
        ZipArchiveEntry entry = null;
        zipOut.setComment("To setup the environment run: source /path/to/eucarc");
        StringBuilder sb = new StringBuilder();
        String userNumber = u.getAccount().getAccountNumber();
        sb.append("EUCA_KEY_DIR=$(cd $(dirname ${BASH_SOURCE:-$0}); pwd -P)");
        Optional<String> computeUrl = X509Download.remotePublicify(Compute.class);
        if (computeUrl.isPresent()) {
            sb.append(X509Download.entryFor("EC2_URL", null, computeUrl));
        } else {
            sb.append("\necho WARN:  Eucalyptus URL is not configured. >&2");
            ServiceBuilder builder = ServiceBuilders.lookup(Compute.class);
            ServiceConfiguration localConfig = builder.newInstance(Internets.localHostAddress(), Internets.localHostAddress(), Internets.localHostAddress(), Eucalyptus.INSTANCE.getPort());
            sb.append("\nexport EC2_URL=" + ServiceUris.remotePublicify((ServiceConfiguration)localConfig, (String[])new String[0]));
        }
        sb.append(X509Download.entryFor("S3_URL", "An OSG is either not registered or not configured. S3_URL is not set. Please register an OSG and/or set a valid s3 endpoint and download credentials again. Or set S3_URL manually to http://OSG-IP:8773/services/objectstorage", X509Download.remotePublicify(ObjectStorage.class)));
        sb.append(X509Download.entryFor("AWS_IAM_URL", "IAM service URL is not configured.", X509Download.remotePublicify(Euare.class)));
        sb.append(X509Download.entryFor("EUARE_URL", "EUARE URL is not configured.", X509Download.remotePublicify(Euare.class)));
        sb.append(X509Download.entryFor("TOKEN_URL", "TOKEN URL is not configured.", X509Download.remotePublicify(Tokens.class)));
        sb.append(X509Download.entryFor("AWS_AUTO_SCALING_URL", "Auto Scaling service URL is not configured.", X509Download.remotePublicify(AutoScaling.class)));
        sb.append(X509Download.entryFor("AWS_CLOUDFORMATION_URL", "CloudFormation service URL is not configured.", X509Download.remotePublicify(CloudFormation.class)));
        sb.append(X509Download.entryFor("AWS_CLOUDWATCH_URL", "CloudWatch service URL is not configured.", X509Download.remotePublicify(CloudWatch.class)));
        sb.append(X509Download.entryFor("AWS_ELB_URL", "Load Balancing service URL is not configured.", X509Download.remotePublicify(LoadBalancing.class)));
        sb.append(X509Download.entryFor("AWS_SIMPLEWORKFLOW_URL", null, X509Download.remotePublicify(SimpleWorkflow.class)));
        sb.append("\nexport EUSTORE_URL=" + StackConfiguration.DEFAULT_EUSTORE_URL);
        String baseName = null;
        if (x509 != null && keyPair != null && (fingerPrint = Certs.getFingerPrint((Key)keyPair.getPublic())) != null) {
            baseName = NAME_SHORT + "-" + u.getName() + "-" + fingerPrint.replaceAll(":", "").toLowerCase().substring(0, 8);
            sb.append("\nexport EC2_PRIVATE_KEY=${EUCA_KEY_DIR}/" + baseName + "-pk.pem");
            sb.append("\nexport EC2_CERT=${EUCA_KEY_DIR}/" + baseName + "-cert.pem");
        }
        sb.append("\nexport EC2_JVM_ARGS=-Djavax.net.ssl.trustStore=${EUCA_KEY_DIR}/jssecacerts");
        sb.append("\nexport EUCALYPTUS_CERT=${EUCA_KEY_DIR}/cloud-cert.pem");
        sb.append("\nexport EC2_ACCOUNT_NUMBER='" + u.getAccount().getAccountNumber() + "'");
        sb.append("\nexport EC2_ACCESS_KEY='" + userAccessKey + "'");
        sb.append("\nexport EC2_SECRET_KEY='" + userSecretKey + "'");
        sb.append("\nexport AWS_ACCESS_KEY='" + userAccessKey + "'");
        sb.append("\nexport AWS_SECRET_KEY='" + userSecretKey + "'");
        sb.append("\nexport AWS_CREDENTIAL_FILE=${EUCA_KEY_DIR}/iamrc");
        sb.append("\nexport EC2_USER_ID='" + userNumber + "'");
        sb.append("\nalias ec2-bundle-image=\"ec2-bundle-image --cert ${EC2_CERT} --privatekey ${EC2_PRIVATE_KEY} --user ${EC2_ACCOUNT_NUMBER} --ec2cert ${EUCALYPTUS_CERT}\"");
        sb.append("\nalias ec2-upload-bundle=\"ec2-upload-bundle -a ${EC2_ACCESS_KEY} -s ${EC2_SECRET_KEY} --url ${S3_URL}\"");
        sb.append("\n");
        entry = new ZipArchiveEntry("eucarc");
        zipOut.putArchiveEntry((ArchiveEntry)entry);
        entry.setUnixMode(384);
        zipOut.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        zipOut.closeArchiveEntry();
        sb = new StringBuilder();
        sb.append("AWSAccessKeyId=").append(userAccessKey).append('\n');
        sb.append("AWSSecretKey=").append(userSecretKey);
        entry = new ZipArchiveEntry("iamrc");
        zipOut.putArchiveEntry((ArchiveEntry)entry);
        entry.setUnixMode(384);
        zipOut.write(sb.toString().getBytes(StandardCharsets.UTF_8));
        zipOut.closeArchiveEntry();
        entry = new ZipArchiveEntry("cloud-cert.pem");
        zipOut.putArchiveEntry((ArchiveEntry)entry);
        entry.setUnixMode(384);
        zipOut.write(PEMFiles.getBytes((Object)cloudCert));
        zipOut.closeArchiveEntry();
        entry = new ZipArchiveEntry("jssecacerts");
        zipOut.putArchiveEntry((ArchiveEntry)entry);
        entry.setUnixMode(384);
        KeyStore tempKs = KeyStore.getInstance("jks");
        tempKs.load(null);
        tempKs.setCertificateEntry("eucalyptus", cloudCert);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        tempKs.store(bos, "changeit".toCharArray());
        zipOut.write(bos.toByteArray());
        zipOut.closeArchiveEntry();
        if (x509 != null && keyPair != null && baseName != null) {
            entry = new ZipArchiveEntry(baseName + "-pk.pem");
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            entry.setUnixMode(384);
            zipOut.write(PEMFiles.getBytes((String)"RSA PRIVATE KEY", (byte[])Crypto.getCertificateProvider().getEncoded(keyPair.getPrivate())));
            zipOut.closeArchiveEntry();
            entry = new ZipArchiveEntry(baseName + "-cert.pem");
            zipOut.putArchiveEntry((ArchiveEntry)entry);
            entry.setUnixMode(384);
            zipOut.write(PEMFiles.getBytes((Object)x509));
            zipOut.closeArchiveEntry();
        }
        zipOut.close();
        return byteOut.toByteArray();
    }

    private static Optional<String> remotePublicify(Class<? extends ComponentId> componentClass) {
        Optional url = Optional.absent();
        if (Topology.isEnabled(componentClass)) {
            try {
                url = Optional.of((Object)X509Download.portUpdate(X509Download.hostMap(ServiceUris.remotePublicify((ServiceConfiguration)Topology.lookup(componentClass, (Partition[])new Partition[0]), (String[])new String[0]))).toString());
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to get URL for service " + componentClass.getSimpleName()), (Throwable)e);
            }
        }
        return url;
    }

    private static URI hostMap(URI uri) {
        Optional mappedHost;
        Host host;
        Optional hostMatcher;
        Optional optional = hostMatcher = InetAddresses.isInetAddress((String)uri.getHost()) ? (Optional)Cidr.parse().apply((Object)AuthenticationProperties.CREDENTIAL_DOWNLOAD_HOST_MATCH) : Optional.absent();
        if (hostMatcher.isPresent() && (host = Hosts.lookup((InetAddress)InetAddresses.forString((String)uri.getHost()))) != null && (mappedHost = Iterables.tryFind((Iterable)host.getHostAddresses(), (Predicate)((Predicate)hostMatcher.get()))).isPresent()) {
            return URI.create(uri.toString().replaceFirst(uri.getHost(), ((InetAddress)mappedHost.get()).getHostAddress()));
        }
        return uri;
    }

    private static URI portUpdate(URI uri) {
        int port = (Integer)Objects.firstNonNull((Object)(AuthenticationProperties.CREDENTIAL_DOWNLOAD_PORT == null ? null : Ints.tryParse((String)AuthenticationProperties.CREDENTIAL_DOWNLOAD_PORT)), (Object)StackConfiguration.PORT);
        try {
            return port != uri.getPort() ? new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment()) : uri;
        }
        catch (URISyntaxException e) {
            return uri;
        }
    }

    private static String entryFor(String variable, String warning, Optional<String> url) {
        if (url.isPresent()) {
            return "\nexport " + variable + "=" + (String)url.get();
        }
        if (warning != null) {
            return "\necho WARN:  " + warning + " >&2";
        }
        return "";
    }

    private static String getError(String message) {
        StringBuilder builder = new StringBuilder();
        builder.append("Getting credentials failed:\n");
        builder.append(message);
        return builder.toString();
    }
}

