/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.www;

import com.eucalyptus.auth.util.Hashes;
import com.eucalyptus.blockstorage.Storage;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.ServiceConfigurations;
import com.eucalyptus.component.ServiceUris;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.NetworkingFeature;
import com.eucalyptus.crypto.Hmac;
import com.eucalyptus.objectstorage.ObjectStorage;
import edu.ucsb.eucalyptus.cloud.entities.SystemConfiguration;
import java.io.IOException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.persistence.PersistenceException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Registration
extends HttpServlet {
    private static Logger LOG = Logger.getLogger(Registration.class);

    private static String getMessage(String key, String uuid) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Signature>\n  <SignedInfo>\n    <SignatureMethod>http://www.w3.org/2001/04/xmldsig-more#hmac-sha256</SignatureMethod>\n  </SignedInfo>\n  <SignatureValue>" + Registration.getSignature(key, uuid) + "</SignatureValue>\n" + "  <Object>\n" + Registration.getConfigurationString(uuid) + "\n</Object>\n" + "</Signature>";
    }

    private static String getConfigurationString(String uuid) {
        return "<CloudSchema>\n  <Services type=\"array\">\n    <Service>\n      <Name>ec2</Name>\n      <EndpointUrl>" + ServiceUris.remote((ServiceConfiguration)Topology.lookup(Compute.class, (Partition[])new Partition[0]), (String[])new String[0]) + "</EndpointUrl>\n" + "      <Resources type=\"array\">\n" + "        <Resource>\n" + "          <Name>instances</Name>\n" + "        </Resource>\n" + "        <Resource>\n" + "          <Name>security_groups</Name>\n" + "        </Resource>\n" + "        <Resource>\n" + "          <Name>ssh_keys</Name>\n" + "        </Resource>\n" + "        <Resource>\n" + "          <Name>images</Name>\n" + "        </Resource>\n" + Registration.blockStorageConfiguration() + Registration.publicAddressConfiguration() + "      </Resources>\n" + "    </Service>\n" + "    <Service>\n" + "      <Name>s3</Name>\n" + "      <EndpointUrl>" + Registration.getWalrusUrl() + "</EndpointUrl>\n" + "      <Resources type=\"array\">\n" + "        <Resource>\n" + "          <Name>buckets</Name>\n" + "        </Resource>\n" + "        <Resource>\n" + "          <Name>keys</Name>\n" + "        </Resource>\n" + "      </Resources>\n" + "    </Service>\n" + "  </Services>\n" + "  <id>" + uuid + "</id>" + "\n  <CloudType>eucalyptus</CloudType>\n" + "  <CloudVersion>" + System.getProperty("euca.version") + "</CloudVersion>\n" + "  <SchemaVersion>1.0</SchemaVersion>\n" + "  <Description>Public cloud in the new cluster</Description>\n" + "  <Credentials type=\"array\">\n" + "    <Credential>\n" + "      <Required type=\"boolean\">false</Required>\n" + "      <Name>username</Name>\n" + "      <Nickname>User ID</Nickname>\n" + "      <Description>Username....</Description>\n" + "    </Credential>\n" + "    <Credential>\n" + "      <Required type=\"boolean\">true</Required>\n" + "      <Name>aws_access_key</Name>\n" + "      <Nickname>Query ID</Nickname>\n" + "      <Description>Access key....</Description>\n" + "    </Credential>\n" + "    <Credential>\n" + "      <Required type=\"boolean\">true</Required>\n" + "      <Name>aws_secret_access_key</Name>\n" + "      <Nickname>Secret Key</Nickname>\n" + "      <Description>Secret Access key....</Description>\n" + "    </Credential>\n" + "  </Credentials>\n" + "</CloudSchema>\n";
    }

    private static String blockStorageConfiguration() {
        try {
            if (!ServiceConfigurations.list(Storage.class).isEmpty()) {
                return "        <Resource>\n          <Name>ebs_snapshots</Name>\n        </Resource>\n        <Resource>\n          <Name>ebs_volumes</Name>\n        </Resource>\n";
            }
        }
        catch (PersistenceException e) {
            LOG.debug((Object)e, (Throwable)e);
        }
        return "";
    }

    private static String publicAddressConfiguration() {
        if (Networking.getInstance().supports(NetworkingFeature.ElasticIPs)) {
            return "        <Resource>\n          <Name>elastic_ips</Name>\n        </Resource>\n";
        }
        return "";
    }

    private static String getWalrusUrl() {
        if (Topology.isEnabled(ObjectStorage.class)) {
            ServiceConfiguration walrusConfig = Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]);
            return ServiceUris.remote((ServiceConfiguration)walrusConfig, (String[])new String[0]).toASCIIString();
        }
        return "NOT REGISTERED.";
    }

    private static String getRegistrationId() {
        return SystemConfiguration.getSystemConfiguration().getRegistrationId();
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String uuid = UUID.randomUUID().toString();
        String registrationId = Registration.getRegistrationId();
        ServletOutputStream op = httpServletResponse.getOutputStream();
        LOG.info((Object)("Using registrationId: " + registrationId));
        op.write(Registration.getMessage(registrationId, UUID.randomUUID().toString()).getBytes());
        op.flush();
    }

    private static String getSignature(String key, String uuid) {
        SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), Hmac.HmacSHA256.toString());
        try {
            Mac mac = Hmac.HmacSHA256.getInstance();
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(uuid.getBytes());
            String sig = Hashes.getHexString((byte[])rawHmac);
            LOG.warn((Object)("\nkey='" + key + "'\nid='" + uuid + "'\nresult=" + sig));
            return sig;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return "error: " + e.getMessage();
        }
    }
}

