/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.www;

import com.eucalyptus.bootstrap.HttpServerBootstrapper;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.eclipse.jetty.rewrite.handler.Rule;

public class Redirect
extends Rule {
    private static final Logger LOG = Logger.getLogger(Redirect.class);

    public Redirect() {
        this.setTerminating(true);
    }

    public String matchAndApply(String target, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String redirectHost = null;
        if (!Topology.isEnabledLocally(Eucalyptus.class)) {
            try {
                ServiceConfiguration clc = Topology.lookup(Eucalyptus.class, (Partition[])new Partition[0]);
                if (clc == null) {
                    throw new RuntimeException("Can not find enabled cloud controller");
                }
                redirectHost = clc.getHostName();
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to lookup service configuration for cloud controller", (Throwable)e);
                throw new IOException("No available cloud web service");
            }
        }
        String urlStr = req.getRequestURL().toString();
        if (redirectHost == null && !urlStr.startsWith("https")) {
            redirectHost = new URL(urlStr).getHost();
        }
        if (redirectHost != null) {
            String redirectUrl = Redirect.getRedirectUrl(redirectHost, req);
            LOG.debug((Object)("Redirecting request to " + redirectUrl));
            resp.sendRedirect(redirectUrl);
        }
        return target;
    }

    private static String getRedirectUrl(String redirectHost, HttpServletRequest req) throws MalformedURLException {
        URL url = new URL(req.getRequestURL().toString());
        return "https://" + String.format("%s:%d/%s", redirectHost, HttpServerBootstrapper.HTTPS_PORT, url.getPath() + (req.getQueryString() != null ? "?" + req.getQueryString() : "")).replaceAll("//", "/");
    }
}

