/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.bootstrap;

import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Bootstrapper;
import com.eucalyptus.bootstrap.DependsLocal;
import com.eucalyptus.bootstrap.Provides;
import com.eucalyptus.bootstrap.RunDuring;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.component.id.HttpService;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.configurable.ConfigurableProperty;
import com.eucalyptus.configurable.ConfigurablePropertyException;
import com.eucalyptus.configurable.PropertyChangeListener;
import com.eucalyptus.crypto.util.SslUtils;
import com.eucalyptus.empyrean.Empyrean;
import com.eucalyptus.system.BaseDirectory;
import com.eucalyptus.system.Threads;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.apache.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.xml.XmlConfiguration;

@Provides(value=Empyrean.class)
@RunDuring(value=Bootstrap.Stage.UserCredentialsInit)
@DependsLocal(value={Eucalyptus.class})
@ConfigurableClass(root="www", description="Parameters controlling the web UI's http server.")
public class HttpServerBootstrapper
extends Bootstrapper {
    private static Logger LOG = Logger.getLogger(HttpServerBootstrapper.class);
    @ConfigurableField(description="Listen to HTTPs on this port.", initial="8443", changeListener=PortChangeListener.class, displayName="euca.https.port")
    public static Integer HTTPS_PORT = 8443;
    @ConfigurableField(description="Listen to HTTP on this port.", initial="8080", changeListener=PortChangeListener.class, displayName="euca.http.port")
    public static Integer HTTP_PORT = 8080;
    private static Server jettyServer;
    @ConfigurableField(initial="", description="Http Proxy Host")
    public static String httpProxyHost;
    @ConfigurableField(initial="", description="Http Proxy Port")
    public static String httpProxyPort;
    @ConfigurableField(description="SSL ciphers for HTTPS listener.", displayName="euca.https.ciphers")
    public static String HTTPS_CIPHERS;
    @ConfigurableField(description="SSL protocols for HTTPS listener.", displayName="euca.https.protocols")
    public static String HTTPS_PROTOCOLS;

    private static void setupJettyServer() throws Exception {
        if (System.getProperty("http.proxyHost") != null) {
            httpProxyHost = System.getProperty("http.proxyHost");
        }
        if (System.getProperty("http.proxyPort") != null) {
            httpProxyPort = System.getProperty("http.proxyPort");
        }
        jettyServer = new Server();
        System.setProperty("org.eclipse.jetty.util.log.DEBUG", "true");
        System.setProperty("euca.http.port", "" + HTTP_PORT);
        System.setProperty("euca.https.port", "" + HTTPS_PORT);
        URL defaultConfig = ClassLoader.getSystemResource("eucalyptus-jetty.xml");
        XmlConfiguration jettyConfig = new XmlConfiguration(defaultConfig);
        jettyConfig.configure((Object)jettyServer);
    }

    private static void delete(File f) throws IOException {
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                HttpServerBootstrapper.delete(file);
            }
        }
        if (!f.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + f);
        }
    }

    private static void startJettyServer() {
        Threads.lookup(HttpService.class, HttpServerBootstrapper.class).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    String path = "/var/run/eucalyptus/webapp";
                    File dir = new File(BaseDirectory.HOME + path);
                    if (dir.exists()) {
                        HttpServerBootstrapper.delete(dir);
                        dir.delete();
                    }
                    jettyServer.start();
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
        });
    }

    public boolean load() throws Exception {
        HttpServerBootstrapper.setupJettyServer();
        return true;
    }

    public boolean start() throws Exception {
        LOG.info((Object)"Starting admin interface.");
        HttpServerBootstrapper.startJettyServer();
        return true;
    }

    public boolean enable() throws Exception {
        return true;
    }

    public boolean stop() throws Exception {
        jettyServer.stop();
        return true;
    }

    public void destroy() throws Exception {
    }

    public boolean disable() throws Exception {
        return true;
    }

    public boolean check() throws Exception {
        return true;
    }

    static {
        HTTPS_CIPHERS = "RSA:DSS:ECDSA:+RC4:+3DES:TLS_EMPTY_RENEGOTIATION_INFO_SCSV:!NULL:!EXPORT:!EXPORT1024:!MD5:!DES";
        HTTPS_PROTOCOLS = "SSLv2Hello,TLSv1,TLSv1.1,TLSv1.2";
    }

    public static final class ConfiguredSslSelectChannelConnector
    extends SslSelectChannelConnector {
        protected SSLEngine createSSLEngine(SocketChannel channel) throws IOException {
            SSLEngine engine = super.createSSLEngine(channel);
            engine.setEnabledCipherSuites(SslUtils.getEnabledCipherSuites((String)HTTPS_CIPHERS, (String[])engine.getSupportedCipherSuites()));
            engine.setEnabledProtocols(SslUtils.getEnabledProtocols((String)HTTPS_PROTOCOLS, (String[])engine.getSupportedProtocols()));
            return engine;
        }
    }

    public static class PortChangeListener
    implements PropertyChangeListener {
        public void fireChange(ConfigurableProperty t, Object newValue) throws ConfigurablePropertyException {
            LOG.warn((Object)("Change occurred to property " + t.getQualifiedName() + " which will restart the servlet container."));
            try {
                t.getField().set(null, t.getTypeParser().apply(newValue));
            }
            catch (IllegalArgumentException e1) {
                throw new ConfigurablePropertyException((Throwable)e1);
            }
            catch (IllegalAccessException e1) {
                throw new ConfigurablePropertyException((Throwable)e1);
            }
            if (jettyServer == null || !Bootstrap.isFinished().booleanValue()) {
                return;
            }
            if (jettyServer.isRunning()) {
                try {
                    jettyServer.stop();
                    for (int i = 0; i < 10 && !jettyServer.isStopped() && jettyServer.isStopping(); ++i) {
                        try {
                            TimeUnit.MILLISECONDS.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    jettyServer.destroy();
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
                try {
                    System.setProperty(t.getDisplayName(), (String)newValue);
                    HttpServerBootstrapper.setupJettyServer();
                    HttpServerBootstrapper.startJettyServer();
                }
                catch (Exception e) {
                    LOG.debug((Object)e, (Throwable)e);
                }
            }
        }
    }
}

