/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.walrus.util;

import com.eucalyptus.util.Internets;
import com.eucalyptus.walrus.exceptions.WalrusException;
import com.eucalyptus.walrus.msgs.WalrusErrorMessageType;
import com.google.common.base.Strings;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EucalyptusErrorMessageType;
import edu.ucsb.eucalyptus.msgs.ExceptionResponseType;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class WalrusUtil {
    public static BaseMessage convertErrorMessage(ExceptionResponseType errorMessage) {
        Throwable ex = errorMessage.getException();
        String correlationId = errorMessage.getCorrelationId();
        BaseMessage errMsg = null;
        errMsg = WalrusUtil.convertException(correlationId, ex);
        if (errMsg == null) {
            errMsg = errorMessage;
        }
        return errMsg;
    }

    public static BaseMessage convertErrorMessage(EucalyptusErrorMessageType errorMessage) {
        Throwable ex = errorMessage.getException();
        String correlationId = errorMessage.getCorrelationId();
        BaseMessage errMsg = null;
        errMsg = WalrusUtil.convertException(correlationId, ex);
        if (errMsg == null) {
            errMsg = errorMessage;
        }
        return errMsg;
    }

    private static BaseMessage convertException(String correlationId, Throwable ex) {
        if (ex instanceof WalrusException) {
            WalrusException e = (WalrusException)ex;
            WalrusErrorMessageType errMsg = new WalrusErrorMessageType(e.getMessage(), e.getCode(), e.getStatus(), e.getResourceType(), e.getResource(), correlationId, Internets.localHostAddress(), e.getLogData());
            errMsg.setCorrelationId(correlationId);
            return errMsg;
        }
        return null;
    }

    public static String URLdecode(String objectKey) throws UnsupportedEncodingException {
        return URLDecoder.decode(objectKey, "UTF-8");
    }

    public static String[] getTarget(String operationPath) {
        String[] parts;
        if ((operationPath = operationPath.replaceAll("^/{2,}", "/")).startsWith("/")) {
            operationPath = operationPath.substring(1);
        }
        if ((parts = operationPath.split("/", 2)) != null) {
            if (parts.length == 1 && Strings.isNullOrEmpty((String)parts[0])) {
                return null;
            }
            if (parts.length == 2 && Strings.isNullOrEmpty((String)parts[1])) {
                return new String[]{parts[0]};
            }
        }
        return parts;
    }
}

